/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.core.validation.rules.invalid.format;

import io.apicurio.datamodels.core.models.common.OAuthFlow;
import io.apicurio.datamodels.core.validation.ValidationRule;
import io.apicurio.datamodels.core.validation.ValidationRuleMetaData;
import io.apicurio.datamodels.openapi.v3.models.Oas30AuthorizationCodeOAuthFlow;
import io.apicurio.datamodels.openapi.v3.models.Oas30ClientCredentialsOAuthFlow;
import io.apicurio.datamodels.openapi.v3.models.Oas30ImplicitOAuthFlow;
import io.apicurio.datamodels.openapi.v3.models.Oas30PasswordOAuthFlow;

public class OasInvalidOAuthTokenUrlRule
extends ValidationRule {
    public OasInvalidOAuthTokenUrlRule(ValidationRuleMetaData ruleInfo) {
        super(ruleInfo);
    }

    protected void visitFlow(OAuthFlow node) {
        if (this.hasValue(node.tokenUrl)) {
            this.reportIfInvalid(this.isValidUrl(node.tokenUrl), node, "tokenUrl", this.map(new String[0]));
        }
    }

    @Override
    public void visitImplicitOAuthFlow(Oas30ImplicitOAuthFlow node) {
        this.visitFlow(node);
    }

    @Override
    public void visitPasswordOAuthFlow(Oas30PasswordOAuthFlow node) {
        this.visitFlow(node);
    }

    @Override
    public void visitClientCredentialsOAuthFlow(Oas30ClientCredentialsOAuthFlow node) {
        this.visitFlow(node);
    }

    @Override
    public void visitAuthorizationCodeOAuthFlow(Oas30AuthorizationCodeOAuthFlow node) {
        this.visitFlow(node);
    }
}

