/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.core.validation.rules.other;

import io.apicurio.datamodels.core.models.common.Operation;
import io.apicurio.datamodels.core.validation.ValidationRule;
import io.apicurio.datamodels.core.validation.ValidationRuleMetaData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OasOperationIdUniquenessValidationRule
extends ValidationRule {
    private Map<String, List<Operation>> indexedOperations = new HashMap<String, List<Operation>>();

    public OasOperationIdUniquenessValidationRule(ValidationRuleMetaData ruleInfo) {
        super(ruleInfo);
    }

    @Override
    public void visitOperation(Operation node) {
        if (this.hasValue(node.operationId)) {
            List<Operation> dupes = this.indexedOperations.get(node.operationId);
            if (this.hasValue(dupes)) {
                this.reportIfInvalid(dupes.size() > 1, dupes.get(0), "operationId", this.map("operationId", node.operationId));
                this.report(node, "operationId", this.map("operationId", node.operationId));
                dupes.add(node);
            } else {
                dupes = new ArrayList<Operation>();
                dupes.add(node);
                this.indexedOperations.put(node.operationId, dupes);
            }
        }
    }
}

