/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.openapi.v2.models;

import io.apicurio.datamodels.core.models.IIndexedNode;
import io.apicurio.datamodels.core.models.Node;
import io.apicurio.datamodels.core.visitors.IVisitor;
import io.apicurio.datamodels.openapi.v2.models.Oas20SecurityScheme;
import io.apicurio.datamodels.openapi.v2.visitors.IOas20Visitor;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Oas20SecurityDefinitions
extends Node
implements IIndexedNode<Oas20SecurityScheme> {
    private Map<String, Oas20SecurityScheme> items;

    @Override
    public void accept(IVisitor visitor) {
        IOas20Visitor viz = (IOas20Visitor)visitor;
        viz.visitSecurityDefinitions(this);
    }

    public List<String> getSecuritySchemeNames() {
        ArrayList<String> rval = new ArrayList<String>();
        if (this.items != null) {
            rval.addAll(this.items.keySet());
        }
        return rval;
    }

    public Oas20SecurityScheme getSecurityScheme(String name) {
        if (this.items != null) {
            return this.items.get(name);
        }
        return null;
    }

    public List<Oas20SecurityScheme> getSecuritySchemes() {
        ArrayList<Oas20SecurityScheme> rval = new ArrayList<Oas20SecurityScheme>();
        if (this.items != null) {
            rval.addAll(this.items.values());
        }
        return rval;
    }

    public void addSecurityScheme(String name, Oas20SecurityScheme scheme) {
        if (this.items == null) {
            this.items = new LinkedHashMap<String, Oas20SecurityScheme>();
        }
        this.items.put(name, scheme);
    }

    public Oas20SecurityScheme removeSecurityScheme(String name) {
        if (this.items != null) {
            return this.items.remove(name);
        }
        return null;
    }

    public Oas20SecurityScheme createSecurityScheme(String name) {
        Oas20SecurityScheme rval = new Oas20SecurityScheme(name);
        rval._ownerDocument = this.ownerDocument();
        rval._parent = this;
        return rval;
    }

    @Override
    public Oas20SecurityScheme getItem(String name) {
        return this.getSecurityScheme(name);
    }

    @Override
    public List<Oas20SecurityScheme> getItems() {
        return this.getSecuritySchemes();
    }

    @Override
    public List<String> getItemNames() {
        return this.getItemNames();
    }

    @Override
    public void addItem(String name, Oas20SecurityScheme item) {
        this.addSecurityScheme(name, item);
    }

    @Override
    public Oas20SecurityScheme deleteItem(String name) {
        return this.removeSecurityScheme(name);
    }
}

