/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.asyncapi.models.AaiOperation;
import io.apicurio.datamodels.cmd.AbstractCommand;
import io.apicurio.datamodels.cmd.util.ModelUtils;
import io.apicurio.datamodels.compat.JsonCompat;
import io.apicurio.datamodels.compat.LoggerCompat;
import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.core.models.NodePath;

public class ChangePayloadRefCommand_Aai20
extends AbstractCommand {
    public NodePath _operationPath;
    public String _payloadRef;
    public String _oldPayloadRef = null;
    public boolean _changed;

    ChangePayloadRefCommand_Aai20() {
    }

    ChangePayloadRefCommand_Aai20(String payloadRef, AaiOperation operationNode) {
        this._operationPath = Library.createNodePath(operationNode);
        this._payloadRef = payloadRef;
    }

    @Override
    public void execute(Document document) {
        Object oldValue;
        LoggerCompat.info("[ChangePayloadRefCommand_Aai20] Executing.", new Object[0]);
        AaiOperation operation = (AaiOperation)this._operationPath.resolve(document);
        this._changed = false;
        if (this.isNullOrUndefined(operation) || this.isNullOrUndefined(operation.message) || !this.isValidRef(this._payloadRef)) {
            return;
        }
        Object payload = operation.message.payload;
        if (payload == null) {
            payload = JsonCompat.objectNode();
        }
        if ((oldValue = JsonCompat.getProperty(payload, "$ref")) != null && JsonCompat.isString(oldValue)) {
            this._oldPayloadRef = JsonCompat.toString(oldValue);
        }
        JsonCompat.setProperty(payload, "$ref", this._payloadRef);
        this._changed = true;
    }

    @Override
    public void undo(Document document) {
        LoggerCompat.info("[ChangePayloadRefCommand_Aai20] Reverting.", new Object[0]);
        AaiOperation operation = (AaiOperation)this._operationPath.resolve(document);
        if (!this._changed || this.isNullOrUndefined(operation) || this.isNullOrUndefined(operation.message)) {
            return;
        }
        Object payload = operation.message.payload;
        if (this._oldPayloadRef != null) {
            JsonCompat.setProperty(payload, "$ref", this._oldPayloadRef);
        } else {
            JsonCompat.consumeProperty(payload, "$ref");
        }
    }

    private boolean isValidRef(String refCandidate) {
        return ModelUtils.isDefined(refCandidate) && refCandidate.startsWith("#/");
    }
}

