/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.cmd.AbstractCommand;
import io.apicurio.datamodels.cmd.models.SimplifiedType;
import io.apicurio.datamodels.cmd.util.SimplifiedTypeUtil;
import io.apicurio.datamodels.compat.LoggerCompat;
import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.core.models.NodePath;
import io.apicurio.datamodels.openapi.models.OasSchema;

public class ChangeSchemaTypeCommand
extends AbstractCommand {
    public NodePath _schemaPath;
    public SimplifiedType _newType;
    public SimplifiedType _oldType;

    ChangeSchemaTypeCommand() {
    }

    ChangeSchemaTypeCommand(OasSchema schema, SimplifiedType newType) {
        this._schemaPath = Library.createNodePath(schema);
        this._newType = newType;
    }

    @Override
    public void execute(Document document) {
        LoggerCompat.info("[ChangeSchemaTypeCommand] Executing: " + this._newType, new Object[0]);
        this._oldType = null;
        OasSchema schema = (OasSchema)this._schemaPath.resolve(document);
        if (this.isNullOrUndefined(schema)) {
            return;
        }
        this._oldType = SimplifiedType.fromSchema(schema);
        SimplifiedTypeUtil.setSimplifiedType(schema, this._newType);
    }

    @Override
    public void undo(Document document) {
        LoggerCompat.info("[ChangeSchemaTypeCommand] Reverting.", new Object[0]);
        if (this._oldType == null) {
            return;
        }
        OasSchema schema = (OasSchema)this._schemaPath.resolve(document);
        if (this.isNullOrUndefined(schema)) {
            return;
        }
        SimplifiedTypeUtil.setSimplifiedType(schema, this._oldType);
    }
}

