/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import io.apicurio.datamodels.asyncapi.models.AaiChannelItem;
import io.apicurio.datamodels.asyncapi.models.AaiDocument;
import io.apicurio.datamodels.cmd.AbstractCommand;
import io.apicurio.datamodels.compat.LoggerCompat;
import io.apicurio.datamodels.core.models.Document;

public class NewChannelCommand
extends AbstractCommand {
    public String _newChannel;
    public boolean _channelExisted;
    public boolean _emptyChannels;

    public NewChannelCommand() {
    }

    public NewChannelCommand(String newChannel) {
        this._newChannel = newChannel;
    }

    @Override
    public void execute(Document document) {
        LoggerCompat.info("[NewChannelCommand] Executing.", new Object[0]);
        AaiDocument adoc = (AaiDocument)document;
        if (adoc.channels != null && adoc.channels.isEmpty()) {
            this._emptyChannels = true;
        }
        if (this.isNullOrUndefined(adoc.channels.get(this._newChannel))) {
            AaiChannelItem channelItem = adoc.createChannelItem(this._newChannel);
            adoc.addChannelItem(channelItem);
            this._channelExisted = false;
        } else {
            this._channelExisted = true;
        }
    }

    @Override
    public void undo(Document document) {
        LoggerCompat.info("[NewChannelCommand] Reverting.", new Object[0]);
        AaiDocument adoc = (AaiDocument)document;
        if (this._channelExisted) {
            LoggerCompat.info("[NewChannelCommand] channel already existed, nothing done so no rollback necessary.", new Object[0]);
            return;
        }
        if (this._emptyChannels) {
            adoc.channels.clear();
        } else {
            adoc.channels.remove(this._newChannel);
        }
    }
}

