/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import io.apicurio.datamodels.asyncapi.models.AaiMessage;
import io.apicurio.datamodels.asyncapi.v2.models.Aai20Components;
import io.apicurio.datamodels.asyncapi.v2.models.Aai20Document;
import io.apicurio.datamodels.asyncapi.v2.models.Aai20NodeFactory;
import io.apicurio.datamodels.cmd.AbstractCommand;
import io.apicurio.datamodels.compat.LoggerCompat;
import io.apicurio.datamodels.core.models.Document;

public class NewMessageDefinitionCommand
extends AbstractCommand {
    public String _newName;
    public String _newDescription;
    public boolean _nullComponents;
    public boolean _defExisted;

    public NewMessageDefinitionCommand() {
    }

    public NewMessageDefinitionCommand(String newName, String newDescription) {
        this._newName = newName;
        this._newDescription = newDescription;
    }

    @Override
    public void execute(Document document) {
        LoggerCompat.info("[NewMessageDefinitionCommand] Executing.", new Object[0]);
        Aai20Document doc20 = (Aai20Document)document;
        if (this.isNullOrUndefined(doc20.components)) {
            doc20.components = doc20.createComponents();
            this._nullComponents = true;
        }
        this._nullComponents = false;
        Aai20Components components = (Aai20Components)doc20.components;
        if (this.isNullOrUndefined(components.getMessageTraitDefinition(this._newName))) {
            Aai20NodeFactory factory = new Aai20NodeFactory();
            AaiMessage msgDef = factory.createMessage(components, this._newName);
            if (!this.isNullOrUndefined(this._newDescription != null)) {
                msgDef.description = this._newDescription;
            }
            components.addMessage(this._newName, msgDef);
            this._defExisted = false;
        } else {
            this._defExisted = true;
        }
    }

    @Override
    public void undo(Document document) {
        LoggerCompat.info("[NewMessageDefinitionCommand] Reverting.", new Object[0]);
        Aai20Document doc20 = (Aai20Document)document;
        if (this._nullComponents) {
            doc20.components = null;
        }
        if (this._defExisted) {
            return;
        }
        doc20.components.removeMessage(this._newName);
    }
}

