/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.asyncapi.models.AaiMessage;
import io.apicurio.datamodels.asyncapi.models.AaiSchema;
import io.apicurio.datamodels.cmd.AbstractCommand;
import io.apicurio.datamodels.cmd.util.ModelUtils;
import io.apicurio.datamodels.combined.visitors.CombinedVisitorAdapter;
import io.apicurio.datamodels.compat.JsonCompat;
import io.apicurio.datamodels.compat.LoggerCompat;
import io.apicurio.datamodels.compat.NodeCompat;
import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.core.models.NodePath;
import io.apicurio.datamodels.core.models.common.IDefinition;
import io.apicurio.datamodels.core.models.common.IPropertySchema;
import io.apicurio.datamodels.core.models.common.Schema;
import io.apicurio.datamodels.core.util.VisitorUtil;
import io.apicurio.datamodels.core.visitors.TraverserDirection;
import io.apicurio.datamodels.openapi.models.OasSchema;
import io.apicurio.datamodels.openapi.v3.models.Oas30Schema;
import java.util.ArrayList;
import java.util.List;

public abstract class RenameSchemaDefinitionCommand
extends AbstractCommand {
    public String _oldName;
    public String _newName;
    public List<NodePath> _references;
    public List<NodePath> _messageReferences;

    RenameSchemaDefinitionCommand() {
    }

    RenameSchemaDefinitionCommand(String oldName, String newName) {
        this._oldName = oldName;
        this._newName = newName;
    }

    @Override
    public void execute(Document document) {
        LoggerCompat.info("[RenameSchemaDefinitionCommand] Executing.", new Object[0]);
        this._references = new ArrayList<NodePath>();
        this._messageReferences = new ArrayList<NodePath>();
        if (this._renameSchemaDefinition(document, this._oldName, this._newName)) {
            String oldRef = this._nameToReference(this._oldName);
            String newRef = this._nameToReference(this._newName);
            SchemaRefFinder schemaFinder = new SchemaRefFinder(oldRef);
            SchemaRefFinder.ReferenceHolder referenceHolder = schemaFinder.findIn(document);
            for (Schema schema : referenceHolder.getSchemas()) {
                this._references.add(Library.createNodePath(schema));
                schema.$ref = newRef;
            }
            for (AaiMessage aaiMessage : referenceHolder.getMessages()) {
                this._messageReferences.add(Library.createNodePath(aaiMessage));
                JsonCompat.setPropertyString(aaiMessage.payload, "$ref", newRef);
            }
        }
    }

    @Override
    public void undo(Document document) {
        LoggerCompat.info("[RenameSchemaDefinitionCommand] Reverting.", new Object[0]);
        if (this._renameSchemaDefinition(document, this._newName, this._oldName)) {
            String oldRef = this._nameToReference(this._oldName);
            if (ModelUtils.isDefined(this._references)) {
                this._references.forEach(ref -> {
                    Schema schema = (Schema)ref.resolve(document);
                    schema.$ref = oldRef;
                });
            }
            if (ModelUtils.isDefined(this._messageReferences)) {
                this._messageReferences.forEach(ref -> {
                    AaiMessage aaiMessage = (AaiMessage)ref.resolve(document);
                    JsonCompat.setPropertyString(aaiMessage.payload, "$ref", oldRef);
                });
            }
        }
    }

    protected abstract String _nameToReference(String var1);

    protected abstract boolean _renameSchemaDefinition(Document var1, String var2, String var3);

    private static class SchemaRefFinder
    extends CombinedVisitorAdapter {
        private String _reference;
        private ReferenceHolder referenceHolder = new ReferenceHolder();

        public SchemaRefFinder(String reference) {
            this._reference = reference;
        }

        public ReferenceHolder findIn(Document document) {
            VisitorUtil.visitTree(document, this, TraverserDirection.down);
            return this.referenceHolder;
        }

        protected boolean _accept(Schema schema) {
            return ModelUtils.isDefined(schema.$ref) && NodeCompat.equals(schema.$ref, this._reference);
        }

        protected boolean _accept(AaiMessage message) {
            return ModelUtils.isDefined(message.payload) && NodeCompat.equals(JsonCompat.getPropertyString(message.payload, "$ref"), this._reference);
        }

        protected void processSchema(Schema schema) {
            if (this._accept(schema)) {
                this.referenceHolder.addSchema(schema);
            }
        }

        protected void processMessage(AaiMessage message) {
            if (this._accept(message)) {
                this.referenceHolder.addMessage(message);
            }
        }

        @Override
        public void visitSchema(Schema node) {
            this.processSchema(node);
        }

        @Override
        public void visitSchemaDefinition(IDefinition node) {
            this.processSchema((Schema)((Object)node));
        }

        @Override
        public void visitPropertySchema(IPropertySchema node) {
            this.processSchema((Schema)((Object)node));
        }

        @Override
        public void visitAdditionalPropertiesSchema(OasSchema node) {
            this.processSchema(node);
        }

        @Override
        public void visitAllOfSchema(OasSchema node) {
            this.processSchema(node);
        }

        @Override
        public void visitItemsSchema(OasSchema node) {
            this.processSchema(node);
        }

        @Override
        public void visitAnyOfSchema(Oas30Schema.Oas30AnyOfSchema node) {
            this.processSchema(node);
        }

        @Override
        public void visitOneOfSchema(Oas30Schema.Oas30OneOfSchema node) {
            this.processSchema(node);
        }

        @Override
        public void visitNotSchema(Oas30Schema.Oas30NotSchema node) {
            this.processSchema(node);
        }

        @Override
        public void visitAllOfSchema(AaiSchema node) {
            this.processSchema(node);
        }

        @Override
        public void visitOneOfSchema(AaiSchema node) {
            this.processSchema(node);
        }

        @Override
        public void visitAnyOfSchema(AaiSchema node) {
            this.processSchema(node);
        }

        @Override
        public void visitNotSchema(AaiSchema node) {
            this.processSchema(node);
        }

        @Override
        public void visitItemsSchema(AaiSchema node) {
            this.processSchema(node);
        }

        @Override
        public void visitAdditionalPropertiesSchema(AaiSchema node) {
            this.processSchema(node);
        }

        @Override
        public void visitMessage(AaiMessage node) {
            this.processMessage(node);
        }

        private static class ReferenceHolder {
            private List<Schema> schemas = new ArrayList<Schema>();
            private List<AaiMessage> messages = new ArrayList<AaiMessage>();

            private ReferenceHolder() {
            }

            public List<Schema> getSchemas() {
                return this.schemas;
            }

            public List<AaiMessage> getMessages() {
                return this.messages;
            }

            public void addSchema(Schema schema) {
                this.schemas.add(schema);
            }

            public void addMessage(AaiMessage aaiMessage) {
                this.messages.add(aaiMessage);
            }
        }
    }
}

