/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.cmd.commands.ReplaceNodeCommand;
import io.apicurio.datamodels.compat.NodeCompat;
import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.openapi.models.OasDocument;
import io.apicurio.datamodels.openapi.models.OasOperation;
import io.apicurio.datamodels.openapi.models.OasPathItem;

public class ReplaceOperationCommand
extends ReplaceNodeCommand<OasOperation> {
    public String _method;
    public String _path;

    ReplaceOperationCommand() {
    }

    ReplaceOperationCommand(OasOperation old, OasOperation replacement) {
        super(old, replacement);
        this._method = old.getMethod();
        this._path = ((OasPathItem)old.parent()).getPath();
    }

    @Override
    protected void removeNode(Document doc, OasOperation node) {
        OasDocument odoc = (OasDocument)doc;
        OasPathItem path = odoc.paths.getPathItem(this._path);
        NodeCompat.setProperty(path, node.getMethod(), null);
    }

    @Override
    protected void addNode(Document doc, OasOperation node) {
        OasDocument odoc = (OasDocument)doc;
        OasPathItem path = odoc.paths.getPathItem(this._path);
        node._parent = path;
        node._ownerDocument = path.ownerDocument();
        NodeCompat.setProperty(path, node.getMethod(), node);
    }

    @Override
    protected OasOperation readNode(Document doc, Object node) {
        OasDocument odoc = (OasDocument)doc;
        OasPathItem parent = odoc.paths.getPathItem(this._path);
        OasOperation operation = parent.createOperation(this._method);
        Library.readNode(node, operation);
        return operation;
    }
}

