/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.core.validation.rules.required;

import io.apicurio.datamodels.compat.NodeCompat;
import io.apicurio.datamodels.core.models.Node;
import io.apicurio.datamodels.core.validation.ValidationRule;
import io.apicurio.datamodels.core.validation.ValidationRuleMetaData;
import java.util.Map;

public abstract class RequiredPropertyValidationRule
extends ValidationRule {
    public RequiredPropertyValidationRule(ValidationRuleMetaData ruleInfo) {
        super(ruleInfo);
    }

    protected void requireProperty(Node node, String propertyName, Map<String, String> messageParams) {
        Object propertyValue = NodeCompat.getProperty(node, propertyName);
        if (!this.isDefined(propertyValue)) {
            this.report(node, propertyName, messageParams);
        }
    }

    protected void requirePropertyWhen(Node node, String propertyName, String dependentPropertyName, Object dependentPropertyExpectedValue, Map<String, String> messageParams) {
        Object dependentPropertyActualValue = NodeCompat.getProperty(node, dependentPropertyName);
        if (NodeCompat.equals(dependentPropertyActualValue, dependentPropertyExpectedValue)) {
            this.requireProperty(node, propertyName, messageParams);
        }
    }
}

