/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.openapi.v3.models;

import io.apicurio.datamodels.compat.NodeCompat;
import io.apicurio.datamodels.core.models.DocumentType;
import io.apicurio.datamodels.core.models.common.ExternalDocumentation;
import io.apicurio.datamodels.core.models.common.IServerParent;
import io.apicurio.datamodels.core.models.common.Info;
import io.apicurio.datamodels.core.models.common.Server;
import io.apicurio.datamodels.core.models.common.Tag;
import io.apicurio.datamodels.openapi.models.OasDocument;
import io.apicurio.datamodels.openapi.models.OasPaths;
import io.apicurio.datamodels.openapi.models.OasSecurityRequirement;
import io.apicurio.datamodels.openapi.v3.models.Oas30Components;
import io.apicurio.datamodels.openapi.v3.models.Oas30ExternalDocumentation;
import io.apicurio.datamodels.openapi.v3.models.Oas30Info;
import io.apicurio.datamodels.openapi.v3.models.Oas30Paths;
import io.apicurio.datamodels.openapi.v3.models.Oas30SecurityRequirement;
import io.apicurio.datamodels.openapi.v3.models.Oas30Server;
import io.apicurio.datamodels.openapi.v3.models.Oas30Tag;
import java.util.ArrayList;
import java.util.List;

public class Oas30Document
extends OasDocument
implements IServerParent {
    public String openapi = "3.0.2";
    public List<Server> servers;
    public Oas30Components components;

    @Override
    public final DocumentType getDocumentType() {
        return DocumentType.openapi3;
    }

    @Override
    public OasPaths createPaths() {
        Oas30Paths rval = new Oas30Paths();
        rval._ownerDocument = this.ownerDocument();
        rval._parent = this;
        return rval;
    }

    @Override
    public OasSecurityRequirement createSecurityRequirement() {
        Oas30SecurityRequirement requirement = new Oas30SecurityRequirement();
        requirement._ownerDocument = this;
        requirement._parent = this;
        return requirement;
    }

    @Override
    public Info createInfo() {
        Oas30Info info = new Oas30Info();
        info._ownerDocument = this;
        info._parent = this;
        return info;
    }

    @Override
    public Tag createTag() {
        Oas30Tag tag = new Oas30Tag();
        tag._ownerDocument = this;
        tag._parent = this;
        return tag;
    }

    @Override
    public ExternalDocumentation createExternalDocumentation() {
        Oas30ExternalDocumentation ed = new Oas30ExternalDocumentation();
        ed._ownerDocument = this;
        ed._parent = this;
        return ed;
    }

    @Override
    public Server createServer() {
        Oas30Server rval = new Oas30Server();
        rval._ownerDocument = this;
        rval._parent = this;
        return rval;
    }

    public Server addServer(String url, String description) {
        Server server = this.createServer();
        server.url = url;
        server.description = description;
        if (this.servers == null) {
            this.servers = new ArrayList<Server>();
        }
        this.servers.add(server);
        return server;
    }

    public Oas30Components createComponents() {
        Oas30Components rval = new Oas30Components();
        rval._ownerDocument = this;
        rval._parent = this;
        return rval;
    }

    @Override
    public void addServer(Server server) {
        if (this.servers == null) {
            this.servers = new ArrayList<Server>();
        }
        this.servers.add(server);
    }

    @Override
    public Server getServer(String url) {
        if (this.servers != null) {
            for (Server server : this.servers) {
                if (!NodeCompat.equals(server.url, url)) continue;
                return server;
            }
        }
        return null;
    }

    @Override
    public List<Server> getServers() {
        return this.servers;
    }
}

