/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.openapi.v3.visitors;

import io.apicurio.datamodels.compat.NodeCompat;
import io.apicurio.datamodels.core.models.common.AuthorizationCodeOAuthFlow;
import io.apicurio.datamodels.core.models.common.ClientCredentialsOAuthFlow;
import io.apicurio.datamodels.core.models.common.Components;
import io.apicurio.datamodels.core.models.common.IDefinition;
import io.apicurio.datamodels.core.models.common.IExample;
import io.apicurio.datamodels.core.models.common.ImplicitOAuthFlow;
import io.apicurio.datamodels.core.models.common.OAuthFlows;
import io.apicurio.datamodels.core.models.common.PasswordOAuthFlow;
import io.apicurio.datamodels.core.models.common.SecurityScheme;
import io.apicurio.datamodels.core.models.common.Server;
import io.apicurio.datamodels.core.models.common.ServerVariable;
import io.apicurio.datamodels.openapi.models.OasHeader;
import io.apicurio.datamodels.openapi.v3.models.Oas30Callback;
import io.apicurio.datamodels.openapi.v3.models.Oas30CallbackDefinition;
import io.apicurio.datamodels.openapi.v3.models.Oas30CallbackPathItem;
import io.apicurio.datamodels.openapi.v3.models.Oas30Discriminator;
import io.apicurio.datamodels.openapi.v3.models.Oas30Encoding;
import io.apicurio.datamodels.openapi.v3.models.Oas30Example;
import io.apicurio.datamodels.openapi.v3.models.Oas30ExampleDefinition;
import io.apicurio.datamodels.openapi.v3.models.Oas30HeaderDefinition;
import io.apicurio.datamodels.openapi.v3.models.Oas30Link;
import io.apicurio.datamodels.openapi.v3.models.Oas30LinkDefinition;
import io.apicurio.datamodels.openapi.v3.models.Oas30LinkParameterExpression;
import io.apicurio.datamodels.openapi.v3.models.Oas30LinkRequestBodyExpression;
import io.apicurio.datamodels.openapi.v3.models.Oas30LinkServer;
import io.apicurio.datamodels.openapi.v3.models.Oas30MediaType;
import io.apicurio.datamodels.openapi.v3.models.Oas30RequestBody;
import io.apicurio.datamodels.openapi.v3.models.Oas30RequestBodyDefinition;
import io.apicurio.datamodels.openapi.v3.models.Oas30Schema;
import io.apicurio.datamodels.openapi.v3.visitors.IOas30Visitor;
import io.apicurio.datamodels.openapi.visitors.OasNodePathVisitor;

public class Oas30NodePathVisitor
extends OasNodePathVisitor
implements IOas30Visitor {
    @Override
    public void visitSchemaDefinition(IDefinition node) {
        this.path.prependSegment(node.getName(), true);
        this.path.prependSegment("schemas", false);
    }

    @Override
    public void visitParameterDefinition(IDefinition node) {
        this.path.prependSegment(node.getName(), true);
        this.path.prependSegment("parameters", false);
    }

    @Override
    public void visitSecurityScheme(SecurityScheme node) {
        this.path.prependSegment(node.getSchemeName(), true);
        this.path.prependSegment("securitySchemes", false);
    }

    @Override
    public void visitResponseDefinition(IDefinition node) {
        this.path.prependSegment(node.getName(), true);
        this.path.prependSegment("responses", false);
    }

    @Override
    public void visitComponents(Components node) {
        this.path.prependSegment("components", false);
    }

    @Override
    public void visitCallbackPathItem(Oas30CallbackPathItem node) {
        this.path.prependSegment(node.getPath(), true);
    }

    @Override
    public void visitCallback(Oas30Callback node) {
        this.path.prependSegment(node.getName(), true);
        this.path.prependSegment("callbacks", false);
    }

    @Override
    public void visitLinkServer(Oas30LinkServer node) {
        this.path.prependSegment("server", false);
    }

    @Override
    public void visitCallbackDefinition(Oas30CallbackDefinition node) {
        this.path.prependSegment(node.getName(), true);
        this.path.prependSegment("callbacks", false);
    }

    @Override
    public void visitLink(Oas30Link node) {
        this.path.prependSegment(node.getName(), true);
        this.path.prependSegment("links", false);
    }

    @Override
    public void visitLinkRequestBodyExpression(Oas30LinkRequestBodyExpression node) {
        this.path.prependSegment("requestBody", false);
    }

    @Override
    public void visitLinkParameterExpression(Oas30LinkParameterExpression node) {
        this.path.prependSegment(node.getName(), true);
        this.path.prependSegment("parameters", false);
    }

    @Override
    public void visitLinkDefinition(Oas30LinkDefinition node) {
        this.path.prependSegment(node.getName(), true);
        this.path.prependSegment("links", false);
    }

    @Override
    public void visitAuthorizationCodeOAuthFlow(AuthorizationCodeOAuthFlow node) {
        this.path.prependSegment("authorizationCode", false);
    }

    @Override
    public void visitClientCredentialsOAuthFlow(ClientCredentialsOAuthFlow node) {
        this.path.prependSegment("clientCredentials", false);
    }

    @Override
    public void visitPasswordOAuthFlow(PasswordOAuthFlow node) {
        this.path.prependSegment("password", false);
    }

    @Override
    public void visitImplicitOAuthFlow(ImplicitOAuthFlow node) {
        this.path.prependSegment("implicit", false);
    }

    @Override
    public void visitOAuthFlows(OAuthFlows node) {
        this.path.prependSegment("flows", false);
    }

    @Override
    public void visitExample(IExample node) {
        Oas30Example example30 = (Oas30Example)node;
        this.path.prependSegment(example30.getName(), true);
        this.path.prependSegment("examples", false);
    }

    @Override
    public void visitEncoding(Oas30Encoding node) {
        this.path.prependSegment(node.getName(), true);
        this.path.prependSegment("encoding", false);
    }

    @Override
    public void visitMediaType(Oas30MediaType node) {
        this.path.prependSegment(node.getName(), true);
        this.path.prependSegment("content", false);
    }

    @Override
    public void visitHeader(OasHeader node) {
        this.path.prependSegment(node.getName(), true);
        this.path.prependSegment("headers", false);
    }

    @Override
    public void visitHeaderDefinition(Oas30HeaderDefinition node) {
        this.path.prependSegment(node.getName(), true);
        this.path.prependSegment("headers", false);
    }

    @Override
    public void visitRequestBody(Oas30RequestBody node) {
        this.path.prependSegment("requestBody", false);
    }

    @Override
    public void visitRequestBodyDefinition(Oas30RequestBodyDefinition node) {
        this.path.prependSegment(node.getName(), true);
        this.path.prependSegment("requestBodies", false);
    }

    @Override
    public void visitExampleDefinition(Oas30ExampleDefinition node) {
        this.path.prependSegment(node.getName(), true);
        this.path.prependSegment("examples", false);
    }

    @Override
    public void visitDiscriminator(Oas30Discriminator node) {
        this.path.prependSegment("discriminator", false);
    }

    @Override
    public void visitNotSchema(Oas30Schema.Oas30NotSchema node) {
        this.path.prependSegment("not", false);
    }

    @Override
    public void visitOneOfSchema(Oas30Schema.Oas30OneOfSchema node) {
        int idx = NodeCompat.indexOf(node, node.parent(), "oneOf");
        if (idx != -1) {
            this.path.prependSegment(String.valueOf(idx), true);
            this.path.prependSegment("oneOf", false);
        }
    }

    @Override
    public void visitAnyOfSchema(Oas30Schema.Oas30AnyOfSchema node) {
        int idx = NodeCompat.indexOf(node, node.parent(), "anyOf");
        if (idx != -1) {
            this.path.prependSegment(String.valueOf(idx), true);
            this.path.prependSegment("anyOf", false);
        }
    }

    @Override
    public void visitServer(Server node) {
        int idx = NodeCompat.indexOf(node, node.parent(), "servers");
        if (idx != -1) {
            this.path.prependSegment(String.valueOf(idx), true);
            this.path.prependSegment("servers", false);
        }
    }

    @Override
    public void visitServerVariable(ServerVariable node) {
        this.path.prependSegment(node.getName(), true);
        this.path.prependSegment("variables", false);
    }
}

