/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.cmd.AbstractCommand;
import io.apicurio.datamodels.compat.LoggerCompat;
import io.apicurio.datamodels.compat.MarshallCompat;
import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.core.models.NodePath;
import io.apicurio.datamodels.core.models.common.IServerParent;
import io.apicurio.datamodels.core.models.common.Server;

public class ChangeServerCommand
extends AbstractCommand {
    public NodePath _parentPath;
    public String _serverUrl;
    @JsonDeserialize(using=MarshallCompat.NullableJsonNodeDeserializer.class)
    public Object _serverObj;
    @JsonDeserialize(using=MarshallCompat.NullableJsonNodeDeserializer.class)
    public Object _oldServer;

    ChangeServerCommand() {
    }

    ChangeServerCommand(Server server) {
        this._parentPath = Library.createNodePath(server.parent());
        this._serverUrl = server.url;
        this._serverObj = Library.writeNode(server);
    }

    @Override
    public void execute(Document document) {
        LoggerCompat.info("[ChangeServerCommand] Executing.", new Object[0]);
        this._oldServer = null;
        IServerParent parent = (IServerParent)((Object)this._parentPath.resolve(document));
        if (this.isNullOrUndefined(parent)) {
            return;
        }
        Server server = parent.getServer(this._serverUrl);
        if (this.isNullOrUndefined(server)) {
            return;
        }
        this._oldServer = Library.writeNode(server);
        this.replaceServerWith(server, this._serverObj);
    }

    @Override
    public void undo(Document document) {
        LoggerCompat.info("[ChangeServerCommand] Reverting.", new Object[0]);
        if (this.isNullOrUndefined(this._oldServer)) {
            return;
        }
        IServerParent parent = (IServerParent)((Object)this._parentPath.resolve(document));
        if (this.isNullOrUndefined(parent)) {
            return;
        }
        Server server = parent.getServer(this._serverUrl);
        if (this.isNullOrUndefined(server)) {
            return;
        }
        this.replaceServerWith(server, this._oldServer);
    }

    protected void replaceServerWith(Server toServer, Object fromServer) {
        toServer.getServerVariables().forEach(var_ -> toServer.removeServerVariable(var_.getName()));
        Library.readNode(fromServer, toServer);
    }
}

