/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.asyncapi.models.AaiMessage;
import io.apicurio.datamodels.asyncapi.v2.models.Aai20Message;
import io.apicurio.datamodels.cmd.AbstractCommand;
import io.apicurio.datamodels.compat.LoggerCompat;
import io.apicurio.datamodels.compat.MarshallCompat;
import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.core.models.NodePath;

public class DeleteOneOfMessageCommand
extends AbstractCommand {
    public int _oneOfIdc;
    public NodePath _parentPath;
    @JsonDeserialize(using=MarshallCompat.NullableJsonNodeDeserializer.class)
    public Object _oldMessage;

    DeleteOneOfMessageCommand() {
    }

    DeleteOneOfMessageCommand(AaiMessage message, int oneOfIdc) {
        this._parentPath = Library.createNodePath(message);
        this._oneOfIdc = oneOfIdc;
    }

    @Override
    public void execute(Document document) {
        LoggerCompat.info("[DeleteOneOfMessageCommand] Executing.", new Object[0]);
        AaiMessage parent = (AaiMessage)this._parentPath.resolve(document);
        AaiMessage res = parent.deleteOneOfMessage(this._oneOfIdc);
        boolean isOneOfMessage = res._isOneOfMessage;
        if (!isOneOfMessage) {
            return;
        }
        if (!this.isNullOrUndefined(res)) {
            this._oldMessage = Library.writeNode(res);
        }
    }

    @Override
    public void undo(Document document) {
        LoggerCompat.info("[DeleteOneOfMessageCommand] Reverting.", new Object[0]);
        if (this.isNullOrUndefined(this._oldMessage)) {
            return;
        }
        AaiMessage parent = (AaiMessage)this._parentPath.resolve(document);
        if (this.isNullOrUndefined(parent)) {
            return;
        }
        Aai20Message message = new Aai20Message(parent);
        Library.readNode(this._oldMessage, message);
        message.setIsOneOfMessage(true);
        parent.addOneOfMessage(message, this._oneOfIdc);
    }
}

