/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.cmd.AbstractCommand;
import io.apicurio.datamodels.compat.LoggerCompat;
import io.apicurio.datamodels.compat.MarshallCompat;
import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.core.models.Node;
import io.apicurio.datamodels.core.models.NodePath;
import io.apicurio.datamodels.core.models.common.ISecurityRequirementParent;
import io.apicurio.datamodels.core.models.common.SecurityRequirement;
import java.util.List;

public class DeleteSecurityRequirementCommand
extends AbstractCommand {
    public NodePath _parentPath;
    @JsonDeserialize(using=MarshallCompat.NullableJsonNodeDeserializer.class)
    public Object _requirement;
    @JsonDeserialize(using=MarshallCompat.NullableJsonNodeDeserializer.class)
    public Object _oldRequirement;

    DeleteSecurityRequirementCommand() {
    }

    DeleteSecurityRequirementCommand(ISecurityRequirementParent parent, SecurityRequirement requirement) {
        this._parentPath = Library.createNodePath((Node)((Object)parent));
        this._requirement = Library.writeNode(requirement);
    }

    @Override
    public void execute(Document document) {
        LoggerCompat.info("[DeleteSecurityRequirementCommand] Executing.", new Object[0]);
        this._oldRequirement = null;
        ISecurityRequirementParent parent = (ISecurityRequirementParent)((Object)this._parentPath.resolve(document));
        if (this.isNullOrUndefined(parent)) {
            return;
        }
        SecurityRequirement requirement = parent.createSecurityRequirement();
        Library.readNode(this._requirement, requirement);
        List<SecurityRequirement> requirements = parent.getSecurityRequirements();
        int idx = this.indexOfRequirement(requirements, requirement);
        if (idx != -1) {
            this._oldRequirement = Library.writeNode(requirements.get(idx));
            requirements.remove(idx);
        }
    }

    @Override
    public void undo(Document document) {
        LoggerCompat.info("[DeleteSecurityRequirementCommand] Reverting.", new Object[0]);
        if (this.isNullOrUndefined(this._oldRequirement)) {
            return;
        }
        ISecurityRequirementParent parent = (ISecurityRequirementParent)((Object)this._parentPath.resolve(document));
        if (this.isNullOrUndefined(parent)) {
            return;
        }
        SecurityRequirement restoredRequirement = parent.createSecurityRequirement();
        Library.readNode(this._oldRequirement, restoredRequirement);
        parent.addSecurityRequirement(restoredRequirement);
    }

    protected int indexOfRequirement(List<SecurityRequirement> requirements, SecurityRequirement requirement) {
        int idx = 0;
        for (SecurityRequirement r : requirements) {
            if (this.isEqual(r, requirement)) {
                return idx;
            }
            ++idx;
        }
        return -1;
    }

    protected boolean isEqual(SecurityRequirement req1, SecurityRequirement req2) {
        List<String> names1 = req1.getSecurityRequirementNames();
        List<String> names2 = req2.getSecurityRequirementNames();
        if (names1.size() != names2.size()) {
            return false;
        }
        boolean rval = true;
        for (String name1 : names1) {
            if (names2.indexOf(name1) != -1 && this.areScopesEqual(req1.getScopes(name1), req2.getScopes(name1))) continue;
            rval = false;
        }
        return rval;
    }

    protected boolean areScopesEqual(List<String> scopes1, List<String> scopes2) {
        if (scopes1.size() != scopes2.size()) {
            return false;
        }
        boolean rval = true;
        for (String scope1 : scopes1) {
            if (scopes2.indexOf(scope1) != -1) continue;
            rval = false;
        }
        return rval;
    }
}

