/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.cmd.AbstractCommand;
import io.apicurio.datamodels.cmd.util.ModelUtils;
import io.apicurio.datamodels.compat.LoggerCompat;
import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.core.models.ExtensibleNode;
import io.apicurio.datamodels.core.models.Extension;
import io.apicurio.datamodels.core.models.NodePath;

public class SetExtensionCommand
extends AbstractCommand {
    public NodePath _parentPath;
    public String _name;
    public Object _value;
    public boolean _hasOldValue;
    public Object _oldValue;

    SetExtensionCommand() {
    }

    SetExtensionCommand(ExtensibleNode parent, String name, Object value) {
        this._parentPath = Library.createNodePath(parent);
        this._name = name;
        this._value = value;
    }

    @Override
    public void execute(Document document) {
        LoggerCompat.info("[SetExtensionCommand] Executing.", new Object[0]);
        this._oldValue = null;
        this._hasOldValue = false;
        ExtensibleNode parent = (ExtensibleNode)this._parentPath.resolve(document);
        if (this.isNullOrUndefined(parent)) {
            return;
        }
        Extension extension = parent.getExtension(this._name);
        if (ModelUtils.isDefined(extension)) {
            this._hasOldValue = true;
            this._oldValue = extension.value;
            extension.value = this._value;
        } else {
            this._hasOldValue = false;
            this._oldValue = null;
            extension = parent.createExtension();
            extension.name = this._name;
            extension.value = this._value;
            parent.addExtension(this._name, extension);
        }
    }

    @Override
    public void undo(Document document) {
        LoggerCompat.info("[SetExtensionCommand] Reverting.", new Object[0]);
        ExtensibleNode parent = (ExtensibleNode)this._parentPath.resolve(document);
        if (this.isNullOrUndefined(parent)) {
            return;
        }
        Extension extension = parent.getExtension(this._name);
        if (this._hasOldValue && ModelUtils.isDefined(extension)) {
            extension.value = this._oldValue;
        }
        if (!this._hasOldValue && ModelUtils.isDefined(extension)) {
            parent.removeExtension(this._name);
        }
    }
}

