/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.core.validation.rules.invalid.reference;

import io.apicurio.datamodels.core.models.DocumentType;
import io.apicurio.datamodels.core.models.common.SecurityScheme;
import io.apicurio.datamodels.core.util.ReferenceUtil;
import io.apicurio.datamodels.core.validation.ValidationRule;
import io.apicurio.datamodels.core.validation.ValidationRuleMetaData;
import io.apicurio.datamodels.openapi.v3.models.Oas30SecurityScheme;

public class OasInvalidSecuritySchemeReferenceRule
extends ValidationRule {
    public OasInvalidSecuritySchemeReferenceRule(ValidationRuleMetaData ruleInfo) {
        super(ruleInfo);
    }

    @Override
    public void visitSecurityScheme(SecurityScheme node) {
        if (node.ownerDocument().getDocumentType() == DocumentType.openapi3) {
            Oas30SecurityScheme node30 = (Oas30SecurityScheme)node;
            if (this.hasValue(node30.$ref)) {
                this.reportIfInvalid(ReferenceUtil.canResolveRef(node30.$ref, node), node, "$ref", this.map(new String[0]));
            }
        }
    }
}

