/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.cmd.AbstractCommand;
import io.apicurio.datamodels.compat.LoggerCompat;
import io.apicurio.datamodels.compat.MarshallCompat;
import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.core.models.NodePath;
import io.apicurio.datamodels.openapi.models.IOasHeaderParent;
import io.apicurio.datamodels.openapi.models.OasHeader;

public class ChangeHeaderCommand
extends AbstractCommand {
    public NodePath _parentPath;
    public String _headerName;
    @JsonDeserialize(using=MarshallCompat.NullableJsonNodeDeserializer.class)
    public Object _newHeader;
    public boolean _changed;
    @JsonDeserialize(using=MarshallCompat.NullableJsonNodeDeserializer.class)
    public Object _oldHeader;

    ChangeHeaderCommand() {
    }

    ChangeHeaderCommand(OasHeader header, OasHeader newHeader) {
        this._headerName = header.getName();
        this._parentPath = Library.createNodePath(header);
        this._newHeader = Library.writeNode(newHeader);
    }

    @Override
    public void execute(Document document) {
        LoggerCompat.info("[ChangeHeaderCommand] Executing.", new Object[0]);
        this._changed = false;
        IOasHeaderParent parent = (IOasHeaderParent)((Object)this._parentPath.resolve(document));
        if (this.isNullOrUndefined(parent)) {
            return;
        }
        OasHeader header = parent.getHeader(this._headerName);
        if (this.isNullOrUndefined(header)) {
            return;
        }
        this._oldHeader = Library.writeNode(header);
        OasHeader newHeader = parent.createHeader(this._headerName);
        Library.readNode(this._newHeader, newHeader);
        this.doChangeHeader(header, newHeader);
        this._changed = true;
    }

    @Override
    public void undo(Document document) {
        LoggerCompat.info("[ChangeHeaderCommand] Reverting.", new Object[0]);
        if (!this._changed) {
            return;
        }
        IOasHeaderParent parent = (IOasHeaderParent)((Object)this._parentPath.resolve(document));
        if (this.isNullOrUndefined(parent)) {
            return;
        }
        OasHeader header = parent.getHeader(this._headerName);
        if (this.isNullOrUndefined(header)) {
            return;
        }
        OasHeader oldHeader = parent.createHeader(this._headerName);
        Library.readNode(this._oldHeader, oldHeader);
        this.doChangeHeader(header, oldHeader);
    }

    protected void doChangeHeader(OasHeader from, OasHeader to) {
        IOasHeaderParent parent = (IOasHeaderParent)((Object)from.parent());
        parent.replaceHeader(this._headerName, to);
    }
}

