/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.asyncapi.models.AaiMessage;
import io.apicurio.datamodels.asyncapi.models.AaiOperation;
import io.apicurio.datamodels.cmd.AbstractCommand;
import io.apicurio.datamodels.compat.JsonCompat;
import io.apicurio.datamodels.compat.LoggerCompat;
import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.core.models.NodePath;

public class ChangePayloadRefCommand_Aai20
extends AbstractCommand {
    public NodePath _operationPath;
    public NodePath _messagePath;
    public String _payloadRef;
    public String _oldPayloadRef = null;
    public boolean _changed;

    ChangePayloadRefCommand_Aai20() {
    }

    @Deprecated
    ChangePayloadRefCommand_Aai20(String payloadRef, AaiOperation operationNode) {
        this._operationPath = Library.createNodePath(operationNode);
        this._payloadRef = payloadRef;
    }

    ChangePayloadRefCommand_Aai20(String payloadRef, AaiMessage messageNode) {
        this._messagePath = Library.createNodePath(messageNode);
        this._payloadRef = payloadRef;
    }

    @Override
    public void execute(Document document) {
        Object oldValue;
        AaiMessage message;
        LoggerCompat.info("[ChangePayloadRefCommand_Aai20] Executing.", new Object[0]);
        this._changed = false;
        if (!this.isNullOrUndefined(this._operationPath)) {
            AaiOperation operation = (AaiOperation)this._operationPath.resolve(document);
            if (this.isNullOrUndefined(operation) || this.isNullOrUndefined(operation.message)) {
                return;
            }
            message = operation.message;
        } else {
            message = (AaiMessage)this._messagePath.resolve(document);
        }
        if (this.isNullOrUndefined(message)) {
            return;
        }
        Object payload = message.payload;
        if (payload == null) {
            payload = JsonCompat.objectNode();
        }
        if ((oldValue = JsonCompat.getProperty(payload, "$ref")) != null && JsonCompat.isString(oldValue)) {
            this._oldPayloadRef = JsonCompat.toString(oldValue);
        }
        JsonCompat.setProperty(payload, "$ref", this._payloadRef);
        this._changed = true;
    }

    @Override
    public void undo(Document document) {
        AaiMessage message;
        LoggerCompat.info("[ChangePayloadRefCommand_Aai20] Reverting.", new Object[0]);
        if (!this._changed) {
            return;
        }
        if (!this.isNullOrUndefined(this._operationPath)) {
            AaiOperation operation = (AaiOperation)this._operationPath.resolve(document);
            if (this.isNullOrUndefined(operation)) {
                return;
            }
            message = operation.message;
        } else {
            message = (AaiMessage)this._messagePath.resolve(document);
        }
        if (this.isNullOrUndefined(message)) {
            return;
        }
        Object payload = message.payload;
        if (this._oldPayloadRef != null) {
            JsonCompat.setProperty(payload, "$ref", this._oldPayloadRef);
        } else {
            JsonCompat.consumeProperty(payload, "$ref");
        }
    }
}

