/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.cmd.AbstractCommand;
import io.apicurio.datamodels.cmd.models.SimplifiedPropertyType;
import io.apicurio.datamodels.cmd.util.ModelUtils;
import io.apicurio.datamodels.cmd.util.SimplifiedTypeUtil;
import io.apicurio.datamodels.compat.LoggerCompat;
import io.apicurio.datamodels.compat.MarshallCompat;
import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.core.models.Node;
import io.apicurio.datamodels.core.models.NodePath;
import io.apicurio.datamodels.core.models.common.IPropertyParent;
import io.apicurio.datamodels.core.models.common.IPropertySchema;
import io.apicurio.datamodels.core.models.common.Schema;
import java.util.ArrayList;
import java.util.List;

public abstract class ChangePropertyTypeCommand
extends AbstractCommand {
    public NodePath _propPath;
    public String _propName;
    public SimplifiedPropertyType _newType;
    @JsonDeserialize(using=MarshallCompat.NullableJsonNodeDeserializer.class)
    public Object _oldProperty;
    public boolean _oldRequired;
    public boolean _nullRequired;
    public Integer _oldRequiredIndex;

    ChangePropertyTypeCommand() {
    }

    ChangePropertyTypeCommand(IPropertySchema property, SimplifiedPropertyType newType) {
        this._propPath = Library.createNodePath((Node)((Object)property));
        this._propName = property.getPropertyName();
        this._newType = newType;
    }

    @Override
    public void execute(Document document) {
        boolean hasRequired;
        LoggerCompat.info("[ChangePropertyTypeCommand] Executing: " + this._newType, new Object[0]);
        IPropertySchema prop = (IPropertySchema)((Object)this._propPath.resolve(document));
        if (this.isNullOrUndefined(prop)) {
            return;
        }
        IPropertyParent parent = (IPropertyParent)((Object)((Node)((Object)prop)).parent());
        List<String> required = parent.getRequiredProperties();
        this._oldProperty = Library.writeNode((Node)((Object)prop));
        boolean bl = hasRequired = ModelUtils.isDefined(required) && required.size() > 0;
        if (hasRequired) {
            int indexOf = required.indexOf(prop.getPropertyName());
            this._oldRequired = indexOf != -1;
            this._oldRequiredIndex = indexOf;
        }
        SimplifiedTypeUtil.setSimplifiedType((Schema)((Object)prop), this._newType);
        if (!this.isNullOrUndefined(this._newType.required)) {
            if (Boolean.TRUE.equals(this._newType.required) && !this._oldRequired) {
                if (this.isNullOrUndefined(required)) {
                    required = new ArrayList<String>();
                    parent.setRequiredProperties(required);
                    this._nullRequired = true;
                }
                required.add(prop.getPropertyName());
            }
            if (Boolean.FALSE.equals(this._newType.required) && this._oldRequired) {
                required.remove(this._oldRequiredIndex);
            }
        }
    }

    @Override
    public void undo(Document document) {
        LoggerCompat.info("[ChangePropertyTypeCommand] Reverting.", new Object[0]);
        IPropertySchema prop = (IPropertySchema)((Object)this._propPath.resolve(document));
        if (this.isNullOrUndefined(prop)) {
            return;
        }
        IPropertyParent parent = (IPropertyParent)((Object)((Node)((Object)prop)).parent());
        List<String> required = parent.getRequiredProperties();
        boolean currentlyRequired = ModelUtils.isDefined(required) && required.size() > 0 && required.indexOf(prop.getPropertyName()) != -1;
        Schema oldProp = parent.createPropertySchema(this._propName);
        Library.readNode(this._oldProperty, oldProp);
        this.restoreSchemaInternalProperties((Schema)((Object)prop), oldProp);
        if (!this.isNullOrUndefined(this._newType.required)) {
            if (this._nullRequired) {
                parent.setRequiredProperties(null);
            } else {
                if (currentlyRequired && !this._oldRequired) {
                    required.remove(required.indexOf(prop.getPropertyName()));
                }
                if (!currentlyRequired && this._oldRequired) {
                    ModelUtils.restoreListEntry(this._oldRequiredIndex, prop.getPropertyName(), required);
                }
            }
        }
    }

    protected abstract void restoreSchemaInternalProperties(Schema var1, Schema var2);
}

