/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.cmd.AbstractCommand;
import io.apicurio.datamodels.cmd.util.ModelUtils;
import io.apicurio.datamodels.compat.LoggerCompat;
import io.apicurio.datamodels.compat.MarshallCompat;
import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.core.models.ExtensibleNode;
import io.apicurio.datamodels.core.models.Extension;
import io.apicurio.datamodels.core.models.NodePath;

public class DeleteExtensionCommand
extends AbstractCommand {
    public NodePath _parentPath;
    public String _name;
    public boolean _hasOldValue;
    public Integer _oldValueIndex;
    @JsonDeserialize(using=MarshallCompat.NullableJsonNodeDeserializer.class)
    public Object _oldValue;

    DeleteExtensionCommand() {
    }

    DeleteExtensionCommand(Extension extension) {
        this._parentPath = Library.createNodePath(extension.parent());
        this._name = extension.name;
    }

    @Override
    public void execute(Document document) {
        LoggerCompat.info("[DeleteExtensionCommand] Executing.", new Object[0]);
        this._oldValue = null;
        this._hasOldValue = false;
        ExtensibleNode parent = (ExtensibleNode)this._parentPath.resolve(document);
        if (this.isNullOrUndefined(parent)) {
            return;
        }
        Extension extension = parent.getExtension(this._name);
        if (ModelUtils.isDefined(extension)) {
            this._hasOldValue = true;
            this._oldValue = extension.value;
            this._oldValueIndex = parent.getExtensionNames().indexOf(this._name);
            parent.removeExtension(this._name);
        } else {
            this._hasOldValue = false;
        }
    }

    @Override
    public void undo(Document document) {
        LoggerCompat.info("[DeleteExtensionCommand] Reverting.", new Object[0]);
        ExtensibleNode parent = (ExtensibleNode)this._parentPath.resolve(document);
        if (this.isNullOrUndefined(parent)) {
            return;
        }
        Extension extension = parent.getExtension(this._name);
        if (this._hasOldValue && ModelUtils.isDefined(extension)) {
            extension.value = this._oldValue;
        }
        if (this._hasOldValue && this.isNullOrUndefined(extension)) {
            Extension ext = parent.createExtension();
            ext.name = this._name;
            ext.value = this._oldValue;
            parent.restoreExtension(this._oldValueIndex, this._name, ext);
        }
    }
}

