/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.cmd.AbstractCommand;
import io.apicurio.datamodels.compat.LoggerCompat;
import io.apicurio.datamodels.compat.MarshallCompat;
import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.core.models.NodePath;
import io.apicurio.datamodels.openapi.v3.models.IOas30MediaTypeParent;
import io.apicurio.datamodels.openapi.v3.models.Oas30MediaType;

public class DeleteMediaTypeCommand
extends AbstractCommand {
    public String _mediaTypeName;
    public NodePath _mediaTypePath;
    public NodePath _parentPath;
    public Integer _oldMediaTypeIndex;
    @JsonDeserialize(using=MarshallCompat.NullableJsonNodeDeserializer.class)
    public Object _oldMediaType;

    DeleteMediaTypeCommand() {
    }

    DeleteMediaTypeCommand(Oas30MediaType mediaType) {
        this._mediaTypeName = mediaType.getName();
        this._mediaTypePath = Library.createNodePath(mediaType);
        this._parentPath = Library.createNodePath(mediaType.parent());
    }

    @Override
    public void execute(Document document) {
        LoggerCompat.info("[DeleteMediaTypeCommand] Executing.", new Object[0]);
        this._oldMediaType = null;
        Oas30MediaType mediaType = (Oas30MediaType)this._mediaTypePath.resolve(document);
        if (this.isNullOrUndefined(mediaType)) {
            return;
        }
        IOas30MediaTypeParent parent = (IOas30MediaTypeParent)((Object)mediaType.parent());
        this._oldMediaTypeIndex = parent.getMediaTypes().indexOf(mediaType);
        parent.removeMediaType(this._mediaTypeName);
        this._oldMediaType = Library.writeNode(mediaType);
    }

    @Override
    public void undo(Document document) {
        LoggerCompat.info("[DeleteMediaTypeCommand] Reverting.", new Object[0]);
        if (this.isNullOrUndefined(this._oldMediaType)) {
            return;
        }
        IOas30MediaTypeParent parent = (IOas30MediaTypeParent)((Object)this._parentPath.resolve(document));
        if (this.isNullOrUndefined(parent)) {
            return;
        }
        Oas30MediaType mediaType = parent.createMediaType(this._mediaTypeName);
        Library.readNode(this._oldMediaType, mediaType);
        parent.restoreMediaType(this._oldMediaTypeIndex, this._mediaTypeName, mediaType);
    }
}

