/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.asyncapi.models.AaiOperation;
import io.apicurio.datamodels.cmd.AbstractCommand;
import io.apicurio.datamodels.cmd.util.ModelUtils;
import io.apicurio.datamodels.compat.JsonCompat;
import io.apicurio.datamodels.compat.LoggerCompat;
import io.apicurio.datamodels.compat.MarshallCompat;
import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.core.models.NodePath;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DeleteMessageExampleCommand_Aai20
extends AbstractCommand {
    public NodePath _parentPath;
    @JsonDeserialize(using=MarshallCompat.NullableJsonNodeDeserializer.class)
    public Object _exampleValue;
    public boolean _exampleRemoved;
    public Integer _oldExampleIndex;

    public DeleteMessageExampleCommand_Aai20() {
    }

    public DeleteMessageExampleCommand_Aai20(AaiOperation operationNode, Object exampleValue) {
        this._parentPath = Library.createNodePath(operationNode);
        this._exampleValue = exampleValue;
    }

    @Override
    public void execute(Document document) {
        LoggerCompat.info("[DeleteMessageExampleCommand_Aai20] Executing.", new Object[0]);
        AaiOperation operation = (AaiOperation)this._parentPath.resolve(document);
        this._exampleRemoved = false;
        if (this.isNullOrUndefined(operation) || this.isNullOrUndefined(operation.message)) {
            return;
        }
        List examples = operation.message.examples;
        if (examples == null) {
            return;
        }
        if (JsonCompat.isString(this._exampleValue)) {
            this._exampleValue = JsonCompat.parseJSON(JsonCompat.toString(this._exampleValue));
        }
        HashMap<String, Object> newExample = new HashMap<String, Object>();
        for (String key : JsonCompat.keys(this._exampleValue)) {
            newExample.put(key, JsonCompat.getProperty(this._exampleValue, key));
        }
        int elementIndex = -1;
        int i = 0;
        while (elementIndex == -1 & i < operation.message.examples.size()) {
            Map example = (Map)operation.message.examples.get(i);
            if (example.size() == newExample.size()) {
                elementIndex = i;
                for (Map.Entry entry : example.entrySet()) {
                    if (newExample.containsKey(entry.getKey()) && JsonCompat.stringify(newExample.get(entry.getKey())).equals(JsonCompat.stringify(entry.getValue()))) continue;
                    elementIndex = -1;
                    break;
                }
            }
            ++i;
        }
        if (elementIndex != -1) {
            operation.message.examples.remove(elementIndex);
            this._oldExampleIndex = elementIndex;
        } else {
            this._oldExampleIndex = null;
        }
        this._exampleRemoved = true;
    }

    @Override
    public void undo(Document document) {
        LoggerCompat.info("[DeleteMessageExampleCommand_Aai20] Reverting.", new Object[0]);
        AaiOperation operation = (AaiOperation)this._parentPath.resolve(document);
        if (!this._exampleRemoved || this.isNullOrUndefined(operation) || this.isNullOrUndefined(operation.message)) {
            return;
        }
        HashMap<String, Object> newExample = new HashMap<String, Object>();
        for (String key : JsonCompat.keys(this._exampleValue)) {
            newExample.put(key, JsonCompat.getProperty(this._exampleValue, key));
        }
        ModelUtils.restoreListEntry(this._oldExampleIndex, newExample, operation.message.examples);
    }
}

