/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.asyncapi.models.AaiOperationTraitDefinition;
import io.apicurio.datamodels.asyncapi.v2.models.Aai20Document;
import io.apicurio.datamodels.asyncapi.v2.models.Aai20NodeFactory;
import io.apicurio.datamodels.cmd.AbstractCommand;
import io.apicurio.datamodels.cmd.util.ModelUtils;
import io.apicurio.datamodels.compat.LoggerCompat;
import io.apicurio.datamodels.compat.MarshallCompat;
import io.apicurio.datamodels.core.models.Document;

public class DeleteOperationTraitDefinitionCommand
extends AbstractCommand {
    public String _name;
    @JsonDeserialize(using=MarshallCompat.NullableJsonNodeDeserializer.class)
    public Object _oldDefinition;
    public Integer _oldDefinitionIndex;

    public DeleteOperationTraitDefinitionCommand() {
    }

    public DeleteOperationTraitDefinitionCommand(String name) {
        this._name = name;
    }

    @Override
    public void execute(Document document) {
        LoggerCompat.info("[DeleteOperationTraitDefinitionCommand] Executing.", new Object[0]);
        Aai20Document doc20 = (Aai20Document)document;
        if (ModelUtils.isDefined(doc20.components)) {
            AaiOperationTraitDefinition traitDef = doc20.components.getOperationTraitDefinition(this._name);
            this._oldDefinitionIndex = doc20.components.getOperationTraitDefinitionsList().indexOf(traitDef);
            doc20.components.removeOperationTraitDefinition(this._name);
            this._oldDefinition = Library.writeNode(traitDef);
        }
    }

    @Override
    public void undo(Document document) {
        LoggerCompat.info("[DeleteOperationTraitDefinitionCommand] Reverting.", new Object[0]);
        if (this.isNullOrUndefined(this._oldDefinition)) {
            return;
        }
        Aai20Document doc20 = (Aai20Document)document;
        if (ModelUtils.isDefined(doc20.components)) {
            Aai20NodeFactory factory = new Aai20NodeFactory();
            AaiOperationTraitDefinition traitDef = factory.createOperationTraitDefinition(doc20.components, this._name);
            Library.readNode(this._oldDefinition, traitDef);
            doc20.components.restoreOperationTraitDefinition(this._oldDefinitionIndex, this._name, traitDef);
        }
    }
}

