/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.cmd.commands.DeleteSchemaDefinitionCommand;
import io.apicurio.datamodels.cmd.util.ModelUtils;
import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.openapi.v3.models.Oas30Document;
import io.apicurio.datamodels.openapi.v3.models.Oas30SchemaDefinition;

public class DeleteSchemaDefinitionCommand_30
extends DeleteSchemaDefinitionCommand {
    public Integer _oldDefinitionIndex;

    DeleteSchemaDefinitionCommand_30() {
    }

    DeleteSchemaDefinitionCommand_30(String definitionName) {
        super(definitionName);
    }

    @Override
    protected Object doDeleteSchemaDefinition(Document document) {
        Oas30Document doc30 = (Oas30Document)document;
        if (ModelUtils.isDefined(doc30.components)) {
            this._oldDefinitionIndex = doc30.components.getSchemaDefinitionNames().indexOf(this._definitionName);
            Oas30SchemaDefinition oldDef = doc30.components.removeSchemaDefinition(this._definitionName);
            return Library.writeNode(oldDef);
        }
        return null;
    }

    @Override
    protected void doRestoreSchemaDefinition(Document document, Object oldDefinition) {
        Oas30Document doc30 = (Oas30Document)document;
        if (ModelUtils.isDefined(doc30.components)) {
            Oas30SchemaDefinition schemaDef = doc30.components.createSchemaDefinition(this._definitionName);
            Library.readNode(oldDefinition, schemaDef);
            doc30.components.restoreSchemaDefinition(this._oldDefinitionIndex, this._definitionName, schemaDef);
        }
    }
}

