/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.asyncapi.models.AaiSchema;
import io.apicurio.datamodels.asyncapi.v2.models.Aai20Document;
import io.apicurio.datamodels.asyncapi.v2.models.Aai20NodeFactory;
import io.apicurio.datamodels.cmd.commands.DeleteSchemaDefinitionCommand;
import io.apicurio.datamodels.cmd.util.ModelUtils;
import io.apicurio.datamodels.core.models.Document;

public class DeleteSchemaDefinitionCommand_Aai20
extends DeleteSchemaDefinitionCommand {
    public Integer _oldDefinitionIndex;

    DeleteSchemaDefinitionCommand_Aai20() {
    }

    DeleteSchemaDefinitionCommand_Aai20(String definitionName) {
        super(definitionName);
    }

    @Override
    protected Object doDeleteSchemaDefinition(Document document) {
        Aai20Document aai20Document = (Aai20Document)document;
        if (ModelUtils.isDefined(aai20Document.components)) {
            this._oldDefinitionIndex = aai20Document.components.getSchemaDefinitionNames().indexOf(this._definitionName);
            AaiSchema oldDef = aai20Document.components.removeSchemaDefinition(this._definitionName);
            return Library.writeNode(oldDef);
        }
        return null;
    }

    @Override
    protected void doRestoreSchemaDefinition(Document document, Object oldDefinition) {
        Aai20Document aai20Document = (Aai20Document)document;
        if (ModelUtils.isDefined(aai20Document.components)) {
            AaiSchema schemaDef = new Aai20NodeFactory().createSchemaDefinition(aai20Document.components, this._definitionName);
            Library.readNode(oldDefinition, schemaDef);
            aai20Document.components.restoreSchemaDefinition(this._oldDefinitionIndex, this._definitionName, schemaDef);
        }
    }
}

