/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.cmd.commands.DeleteSecuritySchemeCommand;
import io.apicurio.datamodels.cmd.util.ModelUtils;
import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.openapi.v3.models.Oas30Document;
import io.apicurio.datamodels.openapi.v3.models.Oas30SecurityScheme;

public class DeleteSecuritySchemeCommand_30
extends DeleteSecuritySchemeCommand {
    public Integer _oldSchemeIndex;

    DeleteSecuritySchemeCommand_30() {
    }

    DeleteSecuritySchemeCommand_30(String schemeName) {
        super(schemeName);
    }

    @Override
    protected Object doDeleteScheme(Document document) {
        Oas30Document doc30 = (Oas30Document)document;
        if (ModelUtils.isDefined(doc30.components)) {
            this._oldSchemeIndex = doc30.components.getSecuritySchemeNames().indexOf(this._schemeName);
            return Library.writeNode(doc30.components.removeSecurityScheme(this._schemeName));
        }
        return null;
    }

    @Override
    protected void doRestoreScheme(Document document, Object oldScheme) {
        Oas30Document doc30 = (Oas30Document)document;
        if (ModelUtils.isDefined(doc30.components)) {
            Oas30SecurityScheme scheme = doc30.components.createSecurityScheme(this._schemeName);
            Library.readNode(oldScheme, scheme);
            doc30.components.restoreSecurityScheme(this._oldSchemeIndex, this._schemeName, scheme);
        }
    }
}

