/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.cmd.AbstractCommand;
import io.apicurio.datamodels.compat.LoggerCompat;
import io.apicurio.datamodels.compat.MarshallCompat;
import io.apicurio.datamodels.compat.NodeCompat;
import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.core.models.NodePath;
import io.apicurio.datamodels.core.models.common.IServerParent;
import io.apicurio.datamodels.core.models.common.Server;
import java.util.ArrayList;
import java.util.List;

public class DeleteServerCommand
extends AbstractCommand {
    public String _serverUrl;
    public NodePath _parentPath;
    @JsonDeserialize(using=MarshallCompat.NullableJsonNodeDeserializer.class)
    public Object _oldServer;
    public Integer _oldServerIndex;

    DeleteServerCommand() {
    }

    DeleteServerCommand(Server server) {
        this._serverUrl = server.url;
        this._parentPath = Library.createNodePath(server.parent());
    }

    @Override
    public void execute(Document document) {
        LoggerCompat.info("[DeleteServerCommand] Executing.", new Object[0]);
        this._oldServer = null;
        IServerParent parent = (IServerParent)((Object)this._parentPath.resolve(document));
        if (this.isNullOrUndefined(parent)) {
            return;
        }
        Server server = parent.getServer(this._serverUrl);
        if (this.isNullOrUndefined(server)) {
            return;
        }
        List<Server> servers = parent.getServers();
        int indexOf = servers.indexOf(server);
        servers.remove(indexOf);
        this._oldServerIndex = indexOf;
        if (servers.size() == 0) {
            NodeCompat.setProperty(parent, "servers", null);
        }
        this._oldServer = Library.writeNode(server);
    }

    @Override
    public void undo(Document document) {
        LoggerCompat.info("[DeleteServerCommand] Reverting.", new Object[0]);
        if (this.isNullOrUndefined(this._oldServer)) {
            return;
        }
        IServerParent parent = (IServerParent)((Object)this._parentPath.resolve(document));
        if (this.isNullOrUndefined(parent)) {
            return;
        }
        Server server = parent.createServer();
        Library.readNode(this._oldServer, server);
        List<Server> servers = parent.getServers();
        if (this.isNullOrUndefined(servers)) {
            servers = new ArrayList<Server>();
            NodeCompat.setProperty(parent, "servers", servers);
        }
        parent.restoreServer(this._oldServerIndex, server);
    }
}

