/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.asyncapi.models.AaiServer;
import io.apicurio.datamodels.asyncapi.v2.models.Aai20Document;
import io.apicurio.datamodels.cmd.AbstractCommand;
import io.apicurio.datamodels.compat.LoggerCompat;
import io.apicurio.datamodels.compat.MarshallCompat;
import io.apicurio.datamodels.compat.NodeCompat;
import io.apicurio.datamodels.core.models.Document;
import java.util.LinkedHashMap;
import java.util.Map;

public class DeleteServerCommand_Aai20
extends AbstractCommand {
    public String _serverName;
    public Integer _oldServerIndex;
    @JsonDeserialize(using=MarshallCompat.NullableJsonNodeDeserializer.class)
    public Object _oldServer;

    DeleteServerCommand_Aai20() {
    }

    DeleteServerCommand_Aai20(AaiServer server) {
        this._serverName = server.getName();
    }

    @Override
    public void execute(Document document) {
        LoggerCompat.info("[DeleteServerCommand_Aai20] Executing.", new Object[0]);
        this._oldServer = null;
        Aai20Document parent = (Aai20Document)document;
        if (this.isNullOrUndefined(parent.servers)) {
            return;
        }
        AaiServer server = (AaiServer)parent.servers.get(this._serverName);
        if (this.isNullOrUndefined(server)) {
            return;
        }
        this._oldServerIndex = parent.getServers().indexOf(server);
        Map servers = parent.servers;
        servers.remove(this._serverName);
        if (servers.size() == 0) {
            NodeCompat.setProperty(parent, "servers", null);
        }
        this._oldServer = Library.writeNode(server);
    }

    @Override
    public void undo(Document document) {
        LoggerCompat.info("[DeleteServerCommand_Aai20] Reverting.", new Object[0]);
        if (this.isNullOrUndefined(this._oldServer)) {
            return;
        }
        Aai20Document parent = (Aai20Document)document;
        if (this.isNullOrUndefined(parent)) {
            return;
        }
        AaiServer server = parent.createServer(this._serverName);
        Library.readNode(this._oldServer, server);
        LinkedHashMap servers = parent.servers;
        if (this.isNullOrUndefined(servers)) {
            servers = new LinkedHashMap();
            NodeCompat.setProperty(parent, "servers", servers);
        }
        parent.restoreServer(this._oldServerIndex, this._serverName, server);
    }
}

