/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.cmd.AbstractCommand;
import io.apicurio.datamodels.cmd.models.SimplifiedPropertyType;
import io.apicurio.datamodels.cmd.util.ModelUtils;
import io.apicurio.datamodels.cmd.util.SimplifiedTypeUtil;
import io.apicurio.datamodels.compat.LoggerCompat;
import io.apicurio.datamodels.compat.NodeCompat;
import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.core.models.Node;
import io.apicurio.datamodels.core.models.NodePath;
import io.apicurio.datamodels.core.models.common.IPropertySchema;
import io.apicurio.datamodels.core.models.common.Schema;
import io.apicurio.datamodels.openapi.models.OasSchema;
import java.util.ArrayList;
import java.util.List;

public class NewSchemaPropertyCommand
extends AbstractCommand {
    public String _propertyName;
    public NodePath _schemaPath;
    public String _description;
    public SimplifiedPropertyType _newType;
    public boolean _created;
    public boolean _nullRequired;

    NewSchemaPropertyCommand() {
    }

    NewSchemaPropertyCommand(Schema schema, String propertyName, String description, SimplifiedPropertyType newType) {
        this._schemaPath = Library.createNodePath(schema);
        this._propertyName = propertyName;
        this._description = description;
        this._newType = newType;
    }

    @Override
    public void execute(Document document) {
        LoggerCompat.info("[NewSchemaPropertyCommand] Executing.", new Object[0]);
        this._created = false;
        OasSchema schema = (OasSchema)this._schemaPath.resolve(document);
        if (this.isNullOrUndefined(schema)) {
            LoggerCompat.info("[NewSchemaPropertyCommand] Schema is null.", new Object[0]);
            return;
        }
        if (ModelUtils.isDefined(schema.getProperty(this._propertyName))) {
            LoggerCompat.info("[NewSchemaPropertyCommand] Property already exists.", new Object[0]);
            return;
        }
        OasSchema property = (OasSchema)schema.createPropertySchema(this._propertyName);
        if (ModelUtils.isDefined(this._description)) {
            property.description = this._description;
        }
        if (ModelUtils.isDefined(this._newType)) {
            this._setPropertyType((IPropertySchema)((Object)property));
        }
        schema.addProperty(this._propertyName, property);
        LoggerCompat.info("[NewSchemaPropertyCommand] Property [%s] created successfully.", this._propertyName);
        this._created = true;
    }

    @Override
    public void undo(Document document) {
        LoggerCompat.info("[NewSchemaPropertyCommand] Reverting.", new Object[0]);
        if (!this._created) {
            return;
        }
        OasSchema schema = (OasSchema)this._schemaPath.resolve(document);
        if (this.isNullOrUndefined(schema)) {
            return;
        }
        if (this.isNullOrUndefined(schema.getProperty(this._propertyName))) {
            return;
        }
        schema.removeProperty(this._propertyName);
        if (ModelUtils.isDefined(this._newType) && this._newType.required == Boolean.TRUE) {
            List<String> required = schema.required;
            required.remove(required.indexOf(this._propertyName));
        }
    }

    protected void _setPropertyType(IPropertySchema prop) {
        SimplifiedTypeUtil.setSimplifiedType((Schema)((Object)prop), this._newType);
        if (ModelUtils.isDefined(this._newType) && this._newType.required == Boolean.TRUE) {
            OasSchema parent = (OasSchema)((Node)((Object)prop)).parent();
            List<String> required = parent.required;
            if (this.isNullOrUndefined(required)) {
                required = new ArrayList<String>();
                NodeCompat.setProperty(parent, "required", required);
                this._nullRequired = true;
            }
            required.add(prop.getPropertyName());
        }
    }
}

