/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import io.apicurio.datamodels.asyncapi.v2.models.Aai20Document;
import io.apicurio.datamodels.cmd.AbstractCommand;
import io.apicurio.datamodels.cmd.util.ModelUtils;
import io.apicurio.datamodels.combined.visitors.CombinedVisitorAdapter;
import io.apicurio.datamodels.compat.LoggerCompat;
import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.core.models.DocumentType;
import io.apicurio.datamodels.core.models.common.SecurityRequirement;
import io.apicurio.datamodels.core.models.common.SecurityScheme;
import io.apicurio.datamodels.core.util.VisitorUtil;
import io.apicurio.datamodels.core.visitors.TraverserDirection;
import io.apicurio.datamodels.openapi.v2.models.Oas20Document;
import io.apicurio.datamodels.openapi.v3.models.Oas30Document;
import java.util.List;
import java.util.function.Consumer;

public class RenameSecuritySchemeCommand
extends AbstractCommand {
    public String _oldSchemeName;
    public String _newSchemeName;

    RenameSecuritySchemeCommand() {
    }

    RenameSecuritySchemeCommand(String oldSchemeName, String newSchemeName) {
        this._oldSchemeName = oldSchemeName;
        this._newSchemeName = newSchemeName;
    }

    @Override
    public void execute(Document document) {
        LoggerCompat.info("[RenameSecuritySchemeCommand] Executing.", new Object[0]);
        this._doSecuritySchemeRename(document, this._oldSchemeName, this._newSchemeName);
    }

    @Override
    public void undo(Document document) {
        LoggerCompat.info("[RenameSecuritySchemeCommand] Reverting.", new Object[0]);
        this._doSecuritySchemeRename(document, this._newSchemeName, this._oldSchemeName);
    }

    private void _doSecuritySchemeRename(Document document, final String from, final String to) {
        Consumer<SecurityScheme> schemeUpdater = scheme -> {
            scheme.rename(to);
            VisitorUtil.visitTree(document, new CombinedVisitorAdapter(){

                @Override
                public void visitSecurityRequirement(SecurityRequirement node) {
                    List<String> scopes = node.removeSecurityRequirementItem(from);
                    if (ModelUtils.isDefined(scopes)) {
                        node.addSecurityRequirementItem(to, scopes);
                    }
                }
            }, TraverserDirection.down);
        };
        if (document.getDocumentType() == DocumentType.openapi2) {
            Oas20Document doc20 = (Oas20Document)document;
            if (ModelUtils.isDefined(doc20.securityDefinitions)) {
                doc20.securityDefinitions.renameSecurityScheme(from, to, schemeUpdater);
            }
        } else if (document.getDocumentType() == DocumentType.openapi3) {
            Oas30Document doc30 = (Oas30Document)document;
            if (ModelUtils.isDefined(doc30.components)) {
                doc30.components.renameSecurityScheme(from, to, schemeUpdater);
            }
        } else {
            Aai20Document aai20Document = (Aai20Document)document;
            if (ModelUtils.isDefined(aai20Document.components)) {
                aai20Document.components.renameSecurityScheme(from, to, schemeUpdater);
            }
        }
    }
}

