/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.asyncapi.v2.models.Aai20Document;
import io.apicurio.datamodels.cmd.AbstractCommand;
import io.apicurio.datamodels.cmd.util.ModelUtils;
import io.apicurio.datamodels.compat.LoggerCompat;
import io.apicurio.datamodels.compat.MarshallCompat;
import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.core.models.Extension;
import io.apicurio.datamodels.core.models.NodePath;
import io.apicurio.datamodels.openapi.models.OasDocument;
import io.apicurio.datamodels.openapi.v2.models.Oas20Document;
import io.apicurio.datamodels.openapi.v3.models.Oas30Document;
import java.util.Collection;
import java.util.LinkedHashMap;

public class ReplaceDocumentCommand
extends AbstractCommand {
    public NodePath _nodePath;
    @JsonDeserialize(using=MarshallCompat.NullableJsonNodeDeserializer.class)
    public Object _new;
    @JsonDeserialize(using=MarshallCompat.NullableJsonNodeDeserializer.class)
    public Object _old;

    ReplaceDocumentCommand() {
    }

    ReplaceDocumentCommand(Document old, Document replacement) {
        this._nodePath = Library.createNodePath(old);
        this._new = Library.writeNode(replacement);
    }

    @Override
    public void execute(Document document) {
        LoggerCompat.info("[ReplaceDocumentCommand] Executing.", new Object[0]);
        this._old = null;
        Document oldNode = (Document)this._nodePath.resolve(document);
        if (this.isNullOrUndefined(oldNode)) {
            return;
        }
        this._old = Library.writeNode(oldNode);
        this.removeNode(document, oldNode);
        this.readNode(document, this._new);
    }

    @Override
    public void undo(Document document) {
        LoggerCompat.info("[ReplaceDocumentCommand] Reverting.", new Object[0]);
        if (this.isNullOrUndefined(this._old)) {
            return;
        }
        Document node = (Document)this._nodePath.resolve(document);
        if (this.isNullOrUndefined(node)) {
            return;
        }
        this.removeNode(document, node);
        this.readNode(document, this._old);
    }

    private void removeNode(Document doc, Document node) {
        switch (node.getDocumentType()) {
            case asyncapi2: {
                this.resetAai2xDocument((Aai20Document)node);
                break;
            }
            case openapi2: {
                this.resetOas2xDocument((Oas20Document)node);
                break;
            }
            case openapi3: {
                this.resetOas3xDocument((Oas30Document)node);
                break;
            }
        }
    }

    private Document readNode(Document doc, Object node) {
        Library.readNode(node, doc);
        return doc;
    }

    private void resetOas2xDocument(Oas20Document doc) {
        doc.host = null;
        doc.basePath = null;
        doc.schemes = null;
        doc.consumes = null;
        doc.produces = null;
        doc.definitions = null;
        doc.parameters = null;
        doc.responses = null;
        doc.securityDefinitions = null;
        this.resetOasDocument(doc);
    }

    private void resetOas3xDocument(Oas30Document doc) {
        doc.servers = null;
        doc.components = null;
        this.resetOasDocument(doc);
    }

    private void resetAai2xDocument(Aai20Document doc) {
        doc.id = null;
        doc.channels = new LinkedHashMap();
        doc.servers = null;
        doc.components = null;
        doc.defaultContentType = null;
        this.resetDocument(doc);
    }

    private void resetOasDocument(OasDocument doc) {
        doc.paths = null;
        doc.security = null;
        this.resetDocument(doc);
    }

    private void resetDocument(Document doc) {
        doc.info = null;
        doc.tags = null;
        doc.externalDocs = null;
        Collection<Extension> extensions = doc.getExtensions();
        if (ModelUtils.isDefined(extensions)) {
            extensions.forEach(ext -> doc.removeExtension(ext.name));
        }
        doc.getExtraPropertyNames().forEach(pname -> doc.removeExtraProperty((String)pname));
    }
}

