/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.cmd.commands.ReplaceNodeCommand;
import io.apicurio.datamodels.compat.NodeCompat;
import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.openapi.models.OasDocument;
import io.apicurio.datamodels.openapi.models.OasOperation;
import io.apicurio.datamodels.openapi.models.OasPathItem;

public class ReplaceOperationCommand
extends ReplaceNodeCommand<OasOperation> {
    public String _method;
    public String _path;

    ReplaceOperationCommand() {
    }

    ReplaceOperationCommand(OasOperation old, OasOperation replacement) {
        super(old, replacement);
        this._method = old.getMethod();
        this._path = ((OasPathItem)old.parent()).getPath();
    }

    @Override
    protected void replaceNode(Document doc, OasOperation newNode) {
        OasDocument odoc = (OasDocument)doc;
        OasPathItem path = odoc.paths.getPathItem(this._path);
        newNode._parent = path;
        newNode._ownerDocument = path.ownerDocument();
        NodeCompat.setProperty(path, newNode.getMethod(), newNode);
    }

    @Override
    protected OasOperation readNode(Document doc, Object node) {
        OasDocument odoc = (OasDocument)doc;
        OasPathItem parent = odoc.paths.getPathItem(this._path);
        OasOperation operation = parent.createOperation(this._method);
        Library.readNode(node, operation);
        return operation;
    }
}

