/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.cmd.commands.ReplaceNodeCommand;
import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.openapi.models.OasDocument;
import io.apicurio.datamodels.openapi.models.OasPathItem;

public class ReplacePathItemCommand
extends ReplaceNodeCommand<OasPathItem> {
    public String _pathName;

    ReplacePathItemCommand() {
    }

    ReplacePathItemCommand(OasPathItem old, OasPathItem replacement) {
        super(old, replacement);
        this._pathName = replacement.getPath();
    }

    @Override
    protected void replaceNode(Document doc, OasPathItem newNode) {
        OasDocument odoc = (OasDocument)doc;
        newNode._ownerDocument = odoc;
        newNode._parent = odoc.paths;
        odoc.paths.replacePathItem(this._pathName, newNode);
    }

    @Override
    protected OasPathItem readNode(Document doc, Object node) {
        OasDocument odoc = (OasDocument)doc;
        OasPathItem pathItem = odoc.paths.createPathItem(this._pathName);
        Library.readNode(node, pathItem);
        return pathItem;
    }
}

