/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.util;

import com.fasterxml.jackson.databind.node.ObjectNode;
import io.apicurio.datamodels.compat.JsonCompat;
import io.apicurio.datamodels.compat.NodeCompat;
import io.apicurio.datamodels.compat.RegexCompat;
import io.apicurio.datamodels.core.models.Extension;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public class ModelUtils {
    public static boolean isNullOrUndefined(Object object) {
        return NodeCompat.isNullOrUndefined(object);
    }

    public static boolean isDefined(Object object) {
        return NodeCompat.isDefined(object);
    }

    public static List<String> detectPathParamNames(String path) {
        ArrayList<String> paramNames = new ArrayList<String>();
        List<String[]> matches = RegexCompat.findMatches(path, "\\{([^\\}]+)\\}");
        for (String[] match : matches) {
            String name = match[1];
            paramNames.add(name.trim());
        }
        return paramNames;
    }

    public static Object marshalExtension(Extension extension) {
        ObjectNode wrapper = JsonCompat.objectNode();
        JsonCompat.setProperty(wrapper, extension.name, extension.value);
        return wrapper;
    }

    public static void unmarshalExtension(Object oldExtension, Extension extension) {
        String name = JsonCompat.keys(oldExtension).get(0);
        Object value = JsonCompat.getPropertyObject(oldExtension, name);
        extension.name = name;
        extension.value = value;
    }

    public static <V extends T, T> Map<String, V> renameMapKey(String oldKey, String newKey, Map<String, V> map, Consumer<T> valueConsumer) {
        if (!NodeCompat.isDefined(map) || !map.containsKey(oldKey) || map.containsKey(newKey)) {
            return map;
        }
        if (!(map instanceof LinkedHashMap)) {
            V value = map.remove(oldKey);
            if (valueConsumer != null) {
                valueConsumer.accept(value);
            }
            map.put(newKey, value);
            return map;
        }
        LinkedHashMap<String, V> newMap = new LinkedHashMap<String, V>();
        for (Map.Entry<String, V> entry : map.entrySet()) {
            String key = entry.getKey();
            V value = entry.getValue();
            if (key.equals(oldKey)) {
                key = newKey;
                if (valueConsumer != null) {
                    valueConsumer.accept(value);
                }
            }
            newMap.put(key, value);
        }
        return newMap;
    }

    public static <V> Map<String, V> restoreMapEntry(Integer position, String key, V value, Map<String, V> map) {
        if (!NodeCompat.isDefined(map)) {
            LinkedHashMap<String, V> newMap = new LinkedHashMap<String, V>();
            newMap.put(key, value);
            return newMap;
        }
        if (map.containsKey(key)) {
            return map;
        }
        if (!(map instanceof LinkedHashMap) || !NodeCompat.isDefined(position) || position >= map.size()) {
            map.put(key, value);
            return map;
        }
        LinkedHashMap<String, V> newMap = new LinkedHashMap<String, V>();
        int index = 0;
        for (Map.Entry<String, V> entry : map.entrySet()) {
            if (index++ == position) {
                newMap.put(key, value);
            }
            newMap.put(entry.getKey(), entry.getValue());
        }
        return newMap;
    }

    public static <V> List<V> restoreListEntry(Integer position, V value, List<V> list) {
        if (!NodeCompat.isDefined(list)) {
            ArrayList<V> newList = new ArrayList<V>();
            newList.add(value);
            return newList;
        }
        if (!NodeCompat.isDefined(position) || position >= list.size()) {
            list.add(value);
        } else if (position < 0) {
            list.add(0, value);
        } else {
            list.add(position, value);
        }
        return list;
    }
}

