/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.core.factories;

import io.apicurio.datamodels.asyncapi.v2.visitors.Aai20Traverser;
import io.apicurio.datamodels.asyncapi.v2.visitors.IAai20Visitor;
import io.apicurio.datamodels.combined.visitors.CombinedReverseTraverser;
import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.core.visitors.ITraverser;
import io.apicurio.datamodels.core.visitors.IVisitor;
import io.apicurio.datamodels.core.visitors.TraverserDirection;
import io.apicurio.datamodels.openapi.v2.visitors.IOas20Visitor;
import io.apicurio.datamodels.openapi.v2.visitors.Oas20Traverser;
import io.apicurio.datamodels.openapi.v3.visitors.IOas30Visitor;
import io.apicurio.datamodels.openapi.v3.visitors.Oas30Traverser;

public class TraverserFactory {
    public static ITraverser create(Document doc, IVisitor visitor, TraverserDirection direction) {
        if (direction == null) {
            direction = TraverserDirection.down;
        }
        switch (doc.getDocumentType()) {
            case asyncapi2: {
                return direction == TraverserDirection.down ? new Aai20Traverser((IAai20Visitor)visitor) : new CombinedReverseTraverser((IAai20Visitor)visitor);
            }
            case openapi2: {
                return direction == TraverserDirection.down ? new Oas20Traverser((IOas20Visitor)visitor) : new CombinedReverseTraverser((IOas20Visitor)visitor);
            }
            case openapi3: {
                return direction == TraverserDirection.down ? new Oas30Traverser((IOas30Visitor)visitor) : new CombinedReverseTraverser((IOas30Visitor)visitor);
            }
        }
        throw new RuntimeException("Failed to create a traverser for document type: " + (Object)((Object)doc.getDocumentType()));
    }
}

