/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.core.models;

import io.apicurio.datamodels.cmd.util.ModelUtils;
import io.apicurio.datamodels.core.models.Extension;
import io.apicurio.datamodels.core.models.Node;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class ExtensibleNode
extends Node {
    protected Map<String, Extension> _extensions;

    @Override
    public boolean isExtensible() {
        return true;
    }

    public Extension createExtension() {
        Extension extension = new Extension();
        extension._ownerDocument = this.ownerDocument();
        extension._parent = this;
        return extension;
    }

    public void addExtension(String name, Extension extension) {
        if (this._extensions == null) {
            this._extensions = new LinkedHashMap<String, Extension>();
        }
        this._extensions.put(name, extension);
    }

    public Collection<Extension> getExtensions() {
        if (this._extensions != null) {
            return new ArrayList<Extension>(this._extensions.values());
        }
        return null;
    }

    public List<String> getExtensionNames() {
        if (this._extensions != null) {
            return new ArrayList<String>(this._extensions.keySet());
        }
        return null;
    }

    public Extension getExtension(String name) {
        Extension rval = null;
        if (this._extensions != null) {
            rval = this._extensions.get(name);
        }
        return rval;
    }

    public void removeExtension(String name) {
        if (this._extensions != null) {
            this._extensions.remove(name);
        }
    }

    public void clearExtensions() {
        if (this._extensions != null) {
            this._extensions.clear();
        }
    }

    public void restoreExtension(Integer oldPosition, String name, Extension ext) {
        this._extensions = ModelUtils.restoreMapEntry(oldPosition, name, ext, this._extensions);
    }
}

