/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.core.validation.rules.invalid.value;

import io.apicurio.datamodels.core.models.common.Operation;
import io.apicurio.datamodels.core.validation.ValidationRule;
import io.apicurio.datamodels.core.validation.ValidationRuleMetaData;
import io.apicurio.datamodels.core.validation.rules.invalid.value.OasInvalidPropertyValueRule;
import io.apicurio.datamodels.openapi.models.OasOperation;
import io.apicurio.datamodels.openapi.models.OasParameter;
import io.apicurio.datamodels.openapi.models.OasPathItem;
import io.apicurio.datamodels.openapi.v3.models.Oas30PathItem;
import java.util.ArrayList;
import java.util.List;

public class OasMissingPathParamDefinitionRule
extends OasInvalidPropertyValueRule {
    private List<String> pathItemsWithError = new ArrayList<String>();

    public OasMissingPathParamDefinitionRule(ValidationRuleMetaData ruleInfo) {
        super(ruleInfo);
    }

    private boolean hasPathParameter(String paramName, List<OasParameter> parameters) {
        for (OasParameter parameter : parameters) {
            if (!this.equals(parameter.in, "path") || !this.equals(parameter.name, paramName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void visitPathItem(OasPathItem node) {
        if (!this.isPathWellFormed(node.getPath())) {
            this.pathItemsWithError.add(node.getPath());
        }
    }

    @Override
    public void visitOperation(Operation node) {
        Oas30PathItem pathItem = (Oas30PathItem)node.parent();
        String path = pathItem.getPath();
        if (this.pathItemsWithError.indexOf(path) != -1) {
            return;
        }
        List<OasParameter> mergedParameters = this.mergeParameters((OasOperation)node);
        List<ValidationRule.PathSegment> pathSegs = this.getPathSegments(path);
        for (ValidationRule.PathSegment pathSeg : pathSegs) {
            if (!this.hasValue(pathSeg.formalName)) continue;
            boolean valid = this.hasPathParameter(pathSeg.formalName, mergedParameters);
            this.reportIfInvalid(valid, node, null, this.map("param", pathSeg.formalName, "path", path, "method", node.getType().toUpperCase()));
        }
    }
}

