/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.core.validation.rules.invalid.value;

import io.apicurio.datamodels.core.models.Node;
import io.apicurio.datamodels.core.models.common.Parameter;
import io.apicurio.datamodels.core.util.ReferenceUtil;
import io.apicurio.datamodels.core.util.VisitorUtil;
import io.apicurio.datamodels.core.validation.ValidationRule;
import io.apicurio.datamodels.core.validation.ValidationRuleMetaData;
import io.apicurio.datamodels.core.validation.rules.invalid.value.OasInvalidPropertyValueRule;
import io.apicurio.datamodels.core.visitors.PathItemFinder;
import io.apicurio.datamodels.core.visitors.TraverserDirection;
import io.apicurio.datamodels.openapi.models.OasParameter;
import io.apicurio.datamodels.openapi.models.OasPathItem;
import java.util.List;

public class OasPathParamNotFoundRule
extends OasInvalidPropertyValueRule {
    public OasPathParamNotFoundRule(ValidationRuleMetaData ruleInfo) {
        super(ruleInfo);
    }

    protected static OasPathItem findPathItem(Node node) {
        PathItemFinder finder = new PathItemFinder();
        VisitorUtil.visitTree(node, finder, TraverserDirection.up);
        return finder.found;
    }

    protected boolean hasPathParamSegment(List<ValidationRule.PathSegment> segments, String paramName) {
        for (ValidationRule.PathSegment seg : segments) {
            if (!this.equals(seg.formalName, paramName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void visitParameter(Parameter node) {
        OasParameter resolvedParam = (OasParameter)ReferenceUtil.resolveNodeRef(node);
        if (this.hasValue(resolvedParam) && this.equals(resolvedParam.in, "path")) {
            OasPathItem pathItem = OasPathParamNotFoundRule.findPathItem(node);
            String path = pathItem.getPath();
            List<ValidationRule.PathSegment> pathSegs = this.getPathSegments(path);
            this.reportIf(!this.hasPathParamSegment(pathSegs, resolvedParam.name), node, "name", this.map("name", resolvedParam.name));
        }
    }
}

