/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.core.validation.rules.invalid.value;

import io.apicurio.datamodels.compat.NodeCompat;
import io.apicurio.datamodels.core.models.common.ServerVariable;
import io.apicurio.datamodels.core.validation.ValidationRuleMetaData;
import io.apicurio.datamodels.core.validation.rules.invalid.value.OasInvalidPropertyValueRule;
import io.apicurio.datamodels.openapi.v3.models.Oas30Server;
import java.util.ArrayList;
import java.util.List;

public class OasServerVarNotFoundInTemplateRule
extends OasInvalidPropertyValueRule {
    public OasServerVarNotFoundInTemplateRule(ValidationRuleMetaData ruleInfo) {
        super(ruleInfo);
    }

    private List<String> parseServerTemplate(String serverTemplate) {
        ArrayList<String> vars = new ArrayList<String>();
        if (!this.hasValue(serverTemplate)) {
            return vars;
        }
        int startIdx = serverTemplate.indexOf("{");
        int endIdx = -1;
        while (startIdx != -1) {
            endIdx = serverTemplate.indexOf(125, startIdx);
            if (endIdx != -1) {
                vars.add(serverTemplate.substring(startIdx + 1, endIdx));
                startIdx = serverTemplate.indexOf(123, endIdx);
                continue;
            }
            startIdx = -1;
        }
        return vars;
    }

    @Override
    public void visitServerVariable(ServerVariable node) {
        String varName = node.getName();
        Oas30Server server = (Oas30Server)node.parent();
        List<String> vars = this.parseServerTemplate(server.url);
        String[] varArray = NodeCompat.asArray(vars);
        this.reportIfInvalid(this.isValidEnumItem(varName, varArray), node, null, this.map("name", varName));
    }
}

