/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.openapi.models;

import io.apicurio.datamodels.cmd.util.ModelUtils;
import io.apicurio.datamodels.core.models.ExtensibleNode;
import io.apicurio.datamodels.core.models.IIndexedNode;
import io.apicurio.datamodels.core.visitors.IVisitor;
import io.apicurio.datamodels.openapi.models.OasPathItem;
import io.apicurio.datamodels.openapi.visitors.IOasVisitor;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class OasPaths
extends ExtensibleNode
implements IIndexedNode<OasPathItem> {
    private Map<String, OasPathItem> _pathItems = new LinkedHashMap<String, OasPathItem>();

    @Override
    public void accept(IVisitor visitor) {
        IOasVisitor oasVisitor = (IOasVisitor)visitor;
        oasVisitor.visitPaths(this);
    }

    public OasPathItem getPathItem(String name) {
        return this._pathItems.get(name);
    }

    public List<OasPathItem> getPathItems() {
        ArrayList<OasPathItem> rval = new ArrayList<OasPathItem>();
        rval.addAll(this._pathItems.values());
        return rval;
    }

    public OasPathItem addPathItem(String name, OasPathItem pathItem) {
        this._pathItems.put(name, pathItem);
        return pathItem;
    }

    public void restorePathItem(Integer index, String name, OasPathItem pathItem) {
        this._pathItems = ModelUtils.restoreMapEntry(index, name, pathItem, this._pathItems);
    }

    public OasPathItem replacePathItem(String name, OasPathItem pathItem) {
        this.addPathItem(name, pathItem);
        return pathItem;
    }

    public List<String> getPathItemNames() {
        ArrayList<String> names = new ArrayList<String>();
        names.addAll(this._pathItems.keySet());
        return names;
    }

    public OasPathItem removePathItem(String path) {
        return this._pathItems.remove(path);
    }

    public OasPathItem renamePathItem(String fromName, String toName) {
        this._pathItems = ModelUtils.renameMapKey(fromName, toName, this._pathItems, path -> path.rename(toName));
        return this._pathItems.get(toName);
    }

    public abstract OasPathItem createPathItem(String var1);

    @Override
    public void addItem(String name, OasPathItem item) {
        this.addPathItem(name, item);
    }

    @Override
    public OasPathItem deleteItem(String name) {
        return this.removePathItem(name);
    }

    @Override
    public OasPathItem getItem(String name) {
        return this.getPathItem(name);
    }

    @Override
    public List<String> getItemNames() {
        return this.getPathItemNames();
    }

    @Override
    public List<OasPathItem> getItems() {
        return this.getPathItems();
    }
}

