/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.openapi.models;

import io.apicurio.datamodels.cmd.util.ModelUtils;
import io.apicurio.datamodels.compat.NodeCompat;
import io.apicurio.datamodels.core.models.ExtensibleNode;
import io.apicurio.datamodels.core.models.IIndexedNode;
import io.apicurio.datamodels.core.visitors.IVisitor;
import io.apicurio.datamodels.openapi.models.OasResponse;
import io.apicurio.datamodels.openapi.visitors.IOasVisitor;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class OasResponses
extends ExtensibleNode
implements IIndexedNode<OasResponse> {
    public OasResponse default_;
    private Map<String, OasResponse> _responses;

    @Override
    public void accept(IVisitor visitor) {
        IOasVisitor viz = (IOasVisitor)visitor;
        viz.visitResponses(this);
    }

    public OasResponse getResponse(String statusCode) {
        if (NodeCompat.equals(statusCode, "default")) {
            return this.default_;
        }
        if (this._responses != null) {
            return this._responses.get(statusCode);
        }
        return null;
    }

    public List<OasResponse> getResponses() {
        ArrayList<OasResponse> rval = new ArrayList<OasResponse>();
        if (this._responses != null) {
            rval.addAll(this._responses.values());
        }
        if (this.default_ != null) {
            rval.add(this.default_);
        }
        return rval;
    }

    public OasResponse addResponse(String statusCode, OasResponse response) {
        if (statusCode == null || NodeCompat.equals(statusCode, "default")) {
            this.default_ = response;
            return response;
        }
        if (this._responses == null) {
            this._responses = new LinkedHashMap<String, OasResponse>();
        }
        this._responses.put(statusCode, response);
        return response;
    }

    public void restoreResponse(Integer index, String statusCode, OasResponse response) {
        if (NodeCompat.isNullOrUndefined(statusCode) || NodeCompat.equals(statusCode, "default")) {
            this.default_ = response;
        } else {
            this._responses = ModelUtils.restoreMapEntry(index, statusCode, response, this._responses);
        }
    }

    public OasResponse removeResponse(String statusCode) {
        if (statusCode == null || NodeCompat.equals(statusCode, "default")) {
            OasResponse rval = this.default_;
            this.default_ = null;
            return rval;
        }
        if (this._responses != null) {
            return this._responses.remove(statusCode);
        }
        return null;
    }

    public List<String> getResponseStatusCodes() {
        ArrayList<String> rval = new ArrayList<String>();
        if (this._responses != null) {
            rval.addAll(this._responses.keySet());
        }
        return rval;
    }

    public abstract OasResponse createResponse(String var1);

    public OasResponse createDefaultResponse() {
        return this.createResponse(null);
    }

    @Override
    public OasResponse getItem(String name) {
        return this.getResponse(name);
    }

    @Override
    public List<OasResponse> getItems() {
        return this.getResponses();
    }

    @Override
    public List<String> getItemNames() {
        return this.getResponseStatusCodes();
    }

    @Override
    public void addItem(String name, OasResponse item) {
        this.addResponse(name, item);
    }

    @Override
    public OasResponse deleteItem(String name) {
        return this.removeResponse(name);
    }
}

