/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.openapi.v2.models;

import io.apicurio.datamodels.cmd.util.ModelUtils;
import io.apicurio.datamodels.core.models.IIndexedNode;
import io.apicurio.datamodels.core.models.Node;
import io.apicurio.datamodels.core.visitors.IVisitor;
import io.apicurio.datamodels.openapi.models.OasHeader;
import io.apicurio.datamodels.openapi.v2.models.Oas20Header;
import io.apicurio.datamodels.openapi.v2.visitors.IOas20Visitor;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public class Oas20Headers
extends Node
implements IIndexedNode<Oas20Header> {
    private Map<String, Oas20Header> items = new LinkedHashMap<String, Oas20Header>();

    @Override
    public void accept(IVisitor visitor) {
        IOas20Visitor viz = (IOas20Visitor)visitor;
        viz.visitHeaders(this);
    }

    public Oas20Header createHeader(String headerName) {
        Oas20Header rval = new Oas20Header(headerName);
        rval._ownerDocument = this.ownerDocument();
        rval._parent = this;
        return rval;
    }

    public Oas20Header getHeader(String headerName) {
        return this.items.get(headerName);
    }

    public List<Oas20Header> getHeaders() {
        ArrayList<Oas20Header> rval = new ArrayList<Oas20Header>();
        rval.addAll(this.items.values());
        return rval;
    }

    public List<String> getHeaderNames() {
        ArrayList<String> rval = new ArrayList<String>();
        rval.addAll(this.items.keySet());
        return rval;
    }

    public Oas20Header removeHeader(String headerName) {
        return this.items.remove(headerName);
    }

    public void renameHeader(String from, String to, Consumer<OasHeader> headerConsumer) {
        this.items = ModelUtils.renameMapKey(from, to, this.items, headerConsumer);
    }

    public void restoreHeader(Integer index, String headerName, Oas20Header header) {
        this.items = ModelUtils.restoreMapEntry(index, headerName, header, this.items);
    }

    public Oas20Header addHeader(String headerName, Oas20Header header) {
        this.items.put(headerName, header);
        return header;
    }

    @Override
    public Oas20Header getItem(String name) {
        return this.getHeader(name);
    }

    @Override
    public List<Oas20Header> getItems() {
        return this.getHeaders();
    }

    @Override
    public List<String> getItemNames() {
        return this.getHeaderNames();
    }

    @Override
    public void addItem(String name, Oas20Header item) {
        this.addHeader(name, item);
    }

    @Override
    public Oas20Header deleteItem(String name) {
        return this.removeHeader(name);
    }
}

