package io.apicurio.datamodels.models;

import java.util.Map;

public interface Components extends Node {

	public SecurityScheme createSecurityScheme();

	public Map<String, SecurityScheme> getSecuritySchemes();

	public void addSecurityScheme(String name, SecurityScheme value);

	public void clearSecuritySchemes();

	public void removeSecurityScheme(String name);

	public Schema createSchema();

	public Map<String, Schema> getSchemas();

	public void addSchema(String name, Schema value);

	public void clearSchemas();

	public void removeSchema(String name);

	public Parameter createParameter();

	public Map<String, Parameter> getParameters();

	public void addParameter(String name, Parameter value);

	public void clearParameters();

	public void removeParameter(String name);
}