package io.apicurio.datamodels.models.asyncapi;

import io.apicurio.datamodels.models.Components;
import java.util.Map;

public interface AsyncApiComponents extends Components {

	public AsyncApiOperationTrait createOperationTrait();

	public Map<String, AsyncApiOperationTrait> getOperationTraits();

	public void addOperationTrait(String name, AsyncApiOperationTrait value);

	public void clearOperationTraits();

	public void removeOperationTrait(String name);

	public AsyncApiMessageTrait createMessageTrait();

	public Map<String, AsyncApiMessageTrait> getMessageTraits();

	public void addMessageTrait(String name, AsyncApiMessageTrait value);

	public void clearMessageTraits();

	public void removeMessageTrait(String name);

	public AsyncApiOperationBindings createOperationBindings();

	public Map<String, AsyncApiOperationBindings> getOperationBindings();

	public void addOperationBinding(String name, AsyncApiOperationBindings value);

	public void clearOperationBindings();

	public void removeOperationBinding(String name);

	public AsyncApiMessage createMessage();

	public Map<String, AsyncApiMessage> getMessages();

	public void addMessage(String name, AsyncApiMessage value);

	public void clearMessages();

	public void removeMessage(String name);

	public AsyncApiMessageBindings createMessageBindings();

	public Map<String, AsyncApiMessageBindings> getMessageBindings();

	public void addMessageBinding(String name, AsyncApiMessageBindings value);

	public void clearMessageBindings();

	public void removeMessageBinding(String name);

	public AsyncApiServerBindings createServerBindings();

	public Map<String, AsyncApiServerBindings> getServerBindings();

	public void addServerBinding(String name, AsyncApiServerBindings value);

	public void clearServerBindings();

	public void removeServerBinding(String name);

	public AsyncApiChannelBindings createChannelBindings();

	public Map<String, AsyncApiChannelBindings> getChannelBindings();

	public void addChannelBinding(String name, AsyncApiChannelBindings value);

	public void clearChannelBindings();

	public void removeChannelBinding(String name);

	public AsyncApiCorrelationID createCorrelationID();

	public Map<String, AsyncApiCorrelationID> getCorrelationIds();

	public void addCorrelationId(String name, AsyncApiCorrelationID value);

	public void clearCorrelationIds();

	public void removeCorrelationId(String name);
}