package io.apicurio.datamodels.models.asyncapi;

import com.fasterxml.jackson.databind.JsonNode;
import io.apicurio.datamodels.models.Node;
import java.util.List;
import java.util.Map;

public interface AsyncApiMessageTrait extends Node {

	public AsyncApiCorrelationID getCorrelationId();

	public void setCorrelationId(AsyncApiCorrelationID value);

	public AsyncApiCorrelationID createCorrelationID();

	public AsyncApiTag createTag();

	public List<AsyncApiTag> getTags();

	public void addTag(AsyncApiTag value);

	public void clearTags();

	public void removeTag(AsyncApiTag value);

	public String getTitle();

	public void setTitle(String value);

	public AsyncApiSchema getHeaders();

	public void setHeaders(AsyncApiSchema value);

	public AsyncApiSchema createSchema();

	public AsyncApiExternalDocumentation getExternalDocs();

	public void setExternalDocs(AsyncApiExternalDocumentation value);

	public AsyncApiExternalDocumentation createExternalDocumentation();

	public String getName();

	public void setName(String value);

	public String getContentType();

	public void setContentType(String value);

	public AsyncApiMessageBindings getBindings();

	public void setBindings(AsyncApiMessageBindings value);

	public AsyncApiMessageBindings createMessageBindings();

	public Map<String, JsonNode> getExamples();

	public void setExamples(Map<String, JsonNode> value);

	public String getSchemaFormat();

	public void setSchemaFormat(String value);

	public String getSummary();

	public void setSummary(String value);

	public String getDescription();

	public void setDescription(String value);
}