package io.apicurio.datamodels.models.asyncapi;

import com.fasterxml.jackson.databind.JsonNode;
import io.apicurio.datamodels.models.Schema;
import io.apicurio.datamodels.models.union.SchemaSchemaListUnion;
import java.util.List;
import java.util.Map;

public interface AsyncApiSchema extends Schema, SchemaSchemaListUnion {

	public AsyncApiSchema getNot();

	public void setNot(AsyncApiSchema value);

	public AsyncApiSchema createSchema();

	public Map<String, String> getPatternProperties();

	public void setPatternProperties(Map<String, String> value);

	public List<JsonNode> getExamples();

	public void setExamples(List<JsonNode> value);

	public JsonNode getConst();

	public void setConst(JsonNode value);

	public Number getExclusiveMinimum();

	public void setExclusiveMinimum(Number value);

	public AsyncApiSchema getElse();

	public void setElse(AsyncApiSchema value);

	public AsyncApiSchema getIf();

	public void setIf(AsyncApiSchema value);

	public AsyncApiSchema getThen();

	public void setThen(AsyncApiSchema value);

	public SchemaSchemaListUnion getItems();

	public void setItems(SchemaSchemaListUnion value);

	public Boolean isWriteOnly();

	public void setWriteOnly(Boolean value);

	public List<AsyncApiSchema> getAnyOf();

	public void addAnyOf(AsyncApiSchema value);

	public void clearAnyOf();

	public void removeAnyOf(AsyncApiSchema value);

	public String getDiscriminator();

	public void setDiscriminator(String value);

	public AsyncApiSchema getContains();

	public void setContains(AsyncApiSchema value);

	public List<AsyncApiSchema> getOneOf();

	public void addOneOf(AsyncApiSchema value);

	public void clearOneOf();

	public void removeOneOf(AsyncApiSchema value);

	public Boolean isDeprecated();

	public void setDeprecated(Boolean value);

	public AsyncApiSchema getPropertyNames();

	public void setPropertyNames(AsyncApiSchema value);

	public AsyncApiSchema getAdditionalItems();

	public void setAdditionalItems(AsyncApiSchema value);

	public Number getExclusiveMaximum();

	public void setExclusiveMaximum(Number value);

	public String getType();

	public void setType(String value);
}