package io.apicurio.datamodels.models.asyncapi.v20;

import io.apicurio.datamodels.models.Node;
import io.apicurio.datamodels.models.NodeImpl;
import io.apicurio.datamodels.models.asyncapi.AsyncApiChannelItem;
import io.apicurio.datamodels.models.asyncapi.v20.visitors.AsyncApi20Visitor;
import io.apicurio.datamodels.models.visitors.Visitor;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class AsyncApi20ChannelsImpl extends NodeImpl implements AsyncApi20Channels {

	private Map<String, AsyncApiChannelItem> _items = new LinkedHashMap<>();

	@Override
	public AsyncApiChannelItem getItem(String name) {
		return this._items.get(name);
	}

	@Override
	public List<AsyncApiChannelItem> getItems() {
		List<AsyncApiChannelItem> rval = new ArrayList<>();
		rval.addAll(this._items.values());
		return rval;
	}

	@Override
	public List<String> getItemNames() {
		List<String> rval = new ArrayList<>();
		rval.addAll(this._items.keySet());
		return rval;
	}

	@Override
	public void addItem(String name, AsyncApiChannelItem item) {
		this._items.put(name, item);
	}

	@Override
	public AsyncApiChannelItem removeItem(String name) {
		return this._items.remove(name);
	}

	@Override
	public AsyncApi20ChannelItem createChannelItem() {
		AsyncApi20ChannelItemImpl node = new AsyncApi20ChannelItemImpl();
		node.setParent(this);
		return node;
	}

	@Override
	public void accept(Visitor visitor) {
		AsyncApi20Visitor viz = (AsyncApi20Visitor) visitor;
		viz.visitChannels(this);
	}

	@Override
	public Node emptyClone() {
		return new AsyncApi20ChannelsImpl();
	}
}