package io.apicurio.datamodels.models.asyncapi.v20;

import io.apicurio.datamodels.models.Node;
import io.apicurio.datamodels.models.NodeImpl;
import io.apicurio.datamodels.models.asyncapi.AsyncApiParameter;
import io.apicurio.datamodels.models.asyncapi.v20.visitors.AsyncApi20Visitor;
import io.apicurio.datamodels.models.visitors.Visitor;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class AsyncApi20ParametersImpl extends NodeImpl implements AsyncApi20Parameters {

	private Map<String, AsyncApiParameter> _items = new LinkedHashMap<>();

	@Override
	public AsyncApiParameter getItem(String name) {
		return this._items.get(name);
	}

	@Override
	public List<AsyncApiParameter> getItems() {
		List<AsyncApiParameter> rval = new ArrayList<>();
		rval.addAll(this._items.values());
		return rval;
	}

	@Override
	public List<String> getItemNames() {
		List<String> rval = new ArrayList<>();
		rval.addAll(this._items.keySet());
		return rval;
	}

	@Override
	public void addItem(String name, AsyncApiParameter item) {
		this._items.put(name, item);
	}

	@Override
	public AsyncApiParameter removeItem(String name) {
		return this._items.remove(name);
	}

	@Override
	public AsyncApi20Parameter createParameter() {
		AsyncApi20ParameterImpl node = new AsyncApi20ParameterImpl();
		node.setParent(this);
		return node;
	}

	@Override
	public void accept(Visitor visitor) {
		AsyncApi20Visitor viz = (AsyncApi20Visitor) visitor;
		viz.visitParameters(this);
	}

	@Override
	public Node emptyClone() {
		return new AsyncApi20ParametersImpl();
	}
}