package io.apicurio.datamodels.models.asyncapi.v21;

import com.fasterxml.jackson.databind.JsonNode;
import io.apicurio.datamodels.models.ExternalDocumentation;
import io.apicurio.datamodels.models.Info;
import io.apicurio.datamodels.models.ModelType;
import io.apicurio.datamodels.models.Node;
import io.apicurio.datamodels.models.RootNodeImpl;
import io.apicurio.datamodels.models.Tag;
import io.apicurio.datamodels.models.asyncapi.AsyncApiChannels;
import io.apicurio.datamodels.models.asyncapi.AsyncApiComponents;
import io.apicurio.datamodels.models.asyncapi.AsyncApiServers;
import io.apicurio.datamodels.models.asyncapi.v21.visitors.AsyncApi21Visitor;
import io.apicurio.datamodels.models.visitors.Visitor;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class AsyncApi21DocumentImpl extends RootNodeImpl implements AsyncApi21Document {

	private String asyncapi;
	private String id;
	private Info info;
	private AsyncApiServers servers;
	private String defaultContentType;
	private AsyncApiChannels channels;
	private AsyncApiComponents components;
	private List<Tag> tags;
	private ExternalDocumentation externalDocs;
	private Map<String, JsonNode> extensions;

	public AsyncApi21DocumentImpl() {
		super(ModelType.ASYNCAPI21);
	}

	@Override
	public String getAsyncapi() {
		return asyncapi;
	}

	@Override
	public void setAsyncapi(String value) {
		this.asyncapi = value;
	}

	@Override
	public String getId() {
		return id;
	}

	@Override
	public void setId(String value) {
		this.id = value;
	}

	@Override
	public Info getInfo() {
		return info;
	}

	@Override
	public void setInfo(Info value) {
		this.info = value;
	}

	@Override
	public AsyncApi21Info createInfo() {
		AsyncApi21InfoImpl node = new AsyncApi21InfoImpl();
		node.setParent(this);
		return node;
	}

	@Override
	public AsyncApiServers getServers() {
		return servers;
	}

	@Override
	public void setServers(AsyncApiServers value) {
		this.servers = value;
	}

	@Override
	public AsyncApi21Servers createServers() {
		AsyncApi21ServersImpl node = new AsyncApi21ServersImpl();
		node.setParent(this);
		return node;
	}

	@Override
	public String getDefaultContentType() {
		return defaultContentType;
	}

	@Override
	public void setDefaultContentType(String value) {
		this.defaultContentType = value;
	}

	@Override
	public AsyncApiChannels getChannels() {
		return channels;
	}

	@Override
	public void setChannels(AsyncApiChannels value) {
		this.channels = value;
	}

	@Override
	public AsyncApi21Channels createChannels() {
		AsyncApi21ChannelsImpl node = new AsyncApi21ChannelsImpl();
		node.setParent(this);
		return node;
	}

	@Override
	public AsyncApiComponents getComponents() {
		return components;
	}

	@Override
	public void setComponents(AsyncApiComponents value) {
		this.components = value;
	}

	@Override
	public AsyncApi21Components createComponents() {
		AsyncApi21ComponentsImpl node = new AsyncApi21ComponentsImpl();
		node.setParent(this);
		return node;
	}

	@Override
	public AsyncApi21Tag createTag() {
		AsyncApi21TagImpl node = new AsyncApi21TagImpl();
		node.setParent(this);
		return node;
	}

	@Override
	public List<Tag> getTags() {
		return tags;
	}

	@Override
	public void addTag(Tag value) {
		if (this.tags == null) {
			this.tags = new ArrayList<>();
		}
		this.tags.add(value);
	}

	@Override
	public void clearTags() {
		if (this.tags != null) {
			this.tags.clear();
		}
	}

	@Override
	public void removeTag(Tag value) {
		if (this.tags != null) {
			this.tags.remove(value);
		}
	}

	@Override
	public ExternalDocumentation getExternalDocs() {
		return externalDocs;
	}

	@Override
	public void setExternalDocs(ExternalDocumentation value) {
		this.externalDocs = value;
	}

	@Override
	public AsyncApi21ExternalDocumentation createExternalDocumentation() {
		AsyncApi21ExternalDocumentationImpl node = new AsyncApi21ExternalDocumentationImpl();
		node.setParent(this);
		return node;
	}

	@Override
	public Map<String, JsonNode> getExtensions() {
		return extensions;
	}

	@Override
	public void addExtension(String name, JsonNode value) {
		if (this.extensions == null) {
			this.extensions = new LinkedHashMap<>();
		}
		this.extensions.put(name, value);
	}

	@Override
	public void clearExtensions() {
		if (this.extensions != null) {
			this.extensions.clear();
		}
	}

	@Override
	public void removeExtension(String name) {
		if (this.extensions != null) {
			this.extensions.remove(name);
		}
	}

	@Override
	public void accept(Visitor visitor) {
		AsyncApi21Visitor viz = (AsyncApi21Visitor) visitor;
		viz.visitDocument(this);
	}

	@Override
	public Node emptyClone() {
		return new AsyncApi21DocumentImpl();
	}
}